/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.catalina.websocket.WsHttpServletRequestWrapper;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.GravityServletUtil;
import org.granite.gravity.tomcat.TomcatWebSocketChannel;
import org.granite.gravity.tomcat.TomcatWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class TomcatWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TomcatWebSocketServlet.class);
    private static Field requestField = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        GravityServletUtil.init((ServletConfig)config);
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        for (String protocol : subProtocols) {
            if (!protocol.startsWith("org.granite.gravity")) continue;
            return protocol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamInbound createWebSocketInbound(String protocol, HttpServletRequest request) {
        GravityInternal gravity = (GravityInternal)GravityManager.getGravity((ServletContext)this.getServletContext());
        TomcatWebSocketChannelFactory channelFactory = new TomcatWebSocketChannelFactory(gravity);
        try {
            ContentType contentType;
            String ctype;
            String connectMessageId = request.getHeader("connectId") != null ? request.getHeader("connectId") : request.getParameter("connectId");
            String clientId = request.getHeader("GDSClientId") != null ? request.getHeader("GDSClientId") : request.getParameter("GDSClientId");
            String clientType = request.getHeader("GDSClientType") != null ? request.getHeader("GDSClientType") : request.getParameter("GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession(false);
            if (session != null) {
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.getServletContext(), (HttpSession)session, (String)clientType);
                sessionId = session.getId();
            } else if (request.getCookies() != null) {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.getServletContext(), (String)sessionId, (String)clientType);
            } else {
                ServletGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), (ServletContext)this.getServletContext(), (String)null, (String)clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", new Object[]{protocol, clientId, sessionId});
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId((Object)clientId);
            }
            Message ackMessage = gravity.handleMessage((ChannelFactory)channelFactory, (Message)pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", (Object)sessionId);
            }
            TomcatWebSocketChannel channel = (TomcatWebSocketChannel)gravity.getChannel((ChannelFactory)channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            if (gravity.getGraniteConfig().getSecurityService() != null) {
                try {
                    gravity.getGraniteConfig().getSecurityService().prelogin(session, request instanceof WsHttpServletRequestWrapper ? requestField.get(request) : request, this.getServletConfig().getServletName());
                }
                catch (IllegalAccessException e) {
                    log.warn((Throwable)e, "Could not get internal request object", new Object[0]);
                }
            }
            if ((ctype = request.getContentType()) == null && protocol.length() > "org.granite.gravity".length()) {
                ctype = "application/x-" + protocol.substring("org.granite.gravity.".length());
            }
            if ((contentType = ContentType.forMimeType((String)ctype)) == null) {
                log.warn("No (or unsupported) content type in request: %s", new Object[]{request.getContentType()});
                contentType = ContentType.AMF;
            }
            channel.setContentType(contentType);
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            StreamInbound streamInbound = channel.getStreamInbound();
            return streamInbound;
        }
        finally {
            GraniteContext.release();
        }
    }

    static {
        try {
            requestField = WsHttpServletRequestWrapper.class.getDeclaredField("request");
            requestField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

