/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.AbstractUdpChannelFactory;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpIOChannel;
import org.granite.gravity.udp.UdpReceiverFactory;
import org.granite.logging.Logger;

public class UdpConnectedIOChannelFactory
extends AbstractUdpChannelFactory {
    private static final Logger log = Logger.getLogger(UdpConnectedIOChannelFactory.class);

    public UdpConnectedIOChannelFactory(UdpReceiverFactory factory) {
        super(factory);
    }

    @Override
    public void start() {
        super.start();
        log.info("UDP socket factory started.", new Object[0]);
    }

    @Override
    public void stop() {
        super.stop();
        log.info("UDP socket factory stopped.", new Object[0]);
    }

    @Override
    public UdpChannel newUdpChannel(AbstractChannel gravityChannel, InetSocketAddress address) {
        int port = this.factory.getPort();
        if (port == 0) {
            log.info("Creating UDP socket on port * (any available port) and connected to %s...", new Object[]{address});
        } else {
            log.info("Creating UDP socket on port %d and connected to %s...", new Object[]{port, address});
        }
        try {
            DatagramSocket socket = new DatagramSocket(port);
            if (port != 0) {
                socket.setReuseAddress(true);
            }
            socket.setSendBufferSize(this.factory.getSendBufferSize());
            socket.connect(address);
            log.info("UDP socket bound to port %d and connected to %s", new Object[]{socket.getLocalPort(), socket.getRemoteSocketAddress()});
            return new UdpIOChannel(this, gravityChannel, socket, address);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data socket on port: " + port, e);
        }
    }
}

