/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.AbstractUdpChannelFactory;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpNIOChannel;
import org.granite.gravity.udp.UdpReceiverFactory;
import org.granite.logging.Logger;

public class UdpSharedNIOChannelFactory
extends AbstractUdpChannelFactory {
    private static final Logger log = Logger.getLogger(UdpSharedNIOChannelFactory.class);
    private DatagramChannel channel = null;

    public UdpSharedNIOChannelFactory(UdpReceiverFactory factory) {
        super(factory);
    }

    @Override
    public void start() {
        super.start();
        int port = this.factory.getPort();
        if (port == 0) {
            log.info("Creating shared UDP channel on port * (any available port)...", new Object[0]);
        } else {
            log.info("Creating shared UDP channel on port %d...", new Object[]{port});
        }
        try {
            this.channel = DatagramChannel.open();
            this.channel.socket().setSendBufferSize(this.factory.getSendBufferSize());
            this.channel.socket().bind(new InetSocketAddress(port));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data channel on port: " + port, e);
        }
        log.info("UDP shared channel bound to port: %d", new Object[]{this.channel.socket().getLocalPort()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        log.info("Closing UDP channel...", new Object[0]);
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                log.error((Throwable)e, "Could not close UDP channel", new Object[0]);
            }
            finally {
                this.channel = null;
            }
        }
        log.info("UDP channel closed.", new Object[0]);
    }

    @Override
    public UdpChannel newUdpChannel(AbstractChannel gravityChannel, InetSocketAddress address) {
        return new UdpNIOChannel(this, gravityChannel, this.channel, address);
    }
}

