/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpChannelFactory;

public abstract class AbstractUdpChannel
implements UdpChannel {
    protected UdpChannelFactory channelFactory = null;
    protected AbstractChannel gravityChannel = null;
    protected InetSocketAddress address = null;

    public AbstractUdpChannel(UdpChannelFactory channelFactory, AbstractChannel gravityChannel, InetSocketAddress address) {
        if (channelFactory == null || gravityChannel == null) {
            throw new NullPointerException();
        }
        this.channelFactory = channelFactory;
        this.gravityChannel = gravityChannel;
        this.address = address;
    }

    @Override
    public AbstractChannel getGravityChannel() {
        return this.gravityChannel;
    }

    @Override
    public int write(byte[] data) throws IOException {
        return this.write(data, 0, data.length);
    }

    @Override
    public void close() {
        this.channelFactory = null;
        this.gravityChannel = null;
        this.address = null;
    }
}

