/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashMap;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.Gravity;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpOutputStream;
import org.granite.gravity.udp.UdpReceiver;
import org.granite.logging.Logger;

public class UdpReceiverImpl
implements UdpReceiver {
    private static final Logger log = Logger.getLogger(UdpReceiverImpl.class);
    public static final String GDS_CLIENT_UPD_PORT = "GDS_CLIENT_UDP_PORT";
    public static final String GDS_SERVER_UDP_PORT = "GDS_SERVER_UDP_PORT";
    private UdpChannel udpChannel;
    private Message connect;

    public UdpReceiverImpl(UdpChannel udpChannel, Message connect) {
        if (udpChannel == null || connect == null) {
            throw new NullPointerException();
        }
        this.udpChannel = udpChannel;
        this.connect = connect;
    }

    public AsyncMessage acknowledge(Message connectMessage) {
        AcknowledgeMessage ack = new AcknowledgeMessage(connectMessage, true);
        ack.setHeader(GDS_SERVER_UDP_PORT, (Object)this.udpChannel.getServerPort());
        return ack;
    }

    public void receive(AsyncMessage message) throws MessageReceivingException {
        AbstractChannel gravityChannel = this.udpChannel.getGravityChannel();
        Gravity gravity = gravityChannel.getGravity();
        message.setCorrelationId(this.connect.getMessageId());
        SimpleGraniteContext context = SimpleGraniteContext.createThreadInstance((GraniteConfig)gravity.getGraniteConfig(), (ServicesConfig)gravity.getServicesConfig(), new HashMap());
        try {
            ((AMFContextImpl)context.getAMFContext()).setCurrentAmf3Message(this.connect);
            UdpOutputStream os = new UdpOutputStream();
            ObjectOutput out = gravityChannel.newSerializer((GraniteContext)context, (OutputStream)os);
            out.writeObject(new Message[]{message});
            int sent = this.udpChannel.write(os.buffer(), 0, os.size());
            if (sent != os.size()) {
                log.debug("Partial data sent: %d of %d", new Object[]{sent, os.size()});
            }
        }
        catch (IOException e) {
            throw new MessageReceivingException((Message)message, (Throwable)e);
        }
        finally {
            GraniteContext.release();
        }
    }

    public boolean isClosed() {
        return this.udpChannel == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean timeout) {
        try {
            this.udpChannel.close();
        }
        finally {
            this.udpChannel = null;
            this.connect = null;
        }
    }
}

