/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.AbstractUdpChannel;
import org.granite.gravity.udp.UdpChannelFactory;
import org.granite.gravity.udp.UdpPacketTooLargeException;

public class UdpNIOChannel
extends AbstractUdpChannel {
    private DatagramChannel channel = null;

    public UdpNIOChannel(UdpChannelFactory channelFactory, AbstractChannel gravityChannel, DatagramChannel channel) {
        this(channelFactory, gravityChannel, channel, null);
    }

    public UdpNIOChannel(UdpChannelFactory channelFactory, AbstractChannel gravityChannel, DatagramChannel channel, InetSocketAddress address) {
        super(channelFactory, gravityChannel, address);
        if (address == null && !channel.isConnected() || address != null && channel.isConnected()) {
            throw new IllegalArgumentException("Inconsistent arguments");
        }
        this.channel = channel;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.channel.isConnected() ? this.channel.socket().getRemoteSocketAddress() : this.address;
    }

    @Override
    public int getServerPort() {
        return this.channel.isConnected() ? this.channel.socket().getLocalPort() : this.address.getPort();
    }

    @Override
    public int write(byte[] data, int offset, int length) throws IOException {
        int size = length - offset;
        if (size > 65536) {
            throw new UdpPacketTooLargeException("UDP packet size cannot exceed 64K: " + size);
        }
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        return this.channel.isConnected() ? this.channel.write(buf) : this.channel.send(buf, this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block5: {
            super.close();
            try {
                if (!this.channel.isConnected()) break block5;
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.channel = null;
            }
        }
    }
}

