/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import flex.messaging.messages.Message;
import java.net.InetSocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.UdpChannelFactory;
import org.granite.gravity.udp.UdpConnectedIOChannelFactory;
import org.granite.gravity.udp.UdpConnectedNIOChannelFactory;
import org.granite.gravity.udp.UdpReceiver;
import org.granite.gravity.udp.UdpReceiverFactory;
import org.granite.gravity.udp.UdpReceiverImpl;
import org.granite.gravity.udp.UdpSharedIOChannelFactory;
import org.granite.gravity.udp.UdpSharedNIOChannelFactory;
import org.granite.logging.Logger;

public class UdpReceiverFactoryImpl
implements UdpReceiverFactory {
    private static final Logger log = Logger.getLogger(UdpReceiverFactoryImpl.class);
    private int port = 0;
    private boolean nio = true;
    private boolean connected = false;
    private int sendBufferSize = 65536;
    private UdpChannelFactory udpChannelFactory = null;

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isNio() {
        return this.nio;
    }

    public void setNio(boolean nio) {
        this.nio = nio;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void start() {
        log.info("Starting UDP Receiver Factory (port=%d, nio=%b, connected=%b, sendBufferSize=%d)", new Object[]{this.port, this.nio, this.connected, this.sendBufferSize});
        this.udpChannelFactory = this.connected ? (this.nio ? new UdpConnectedNIOChannelFactory(this) : new UdpConnectedIOChannelFactory(this)) : (this.nio ? new UdpSharedNIOChannelFactory(this) : new UdpSharedIOChannelFactory(this));
        this.udpChannelFactory.start();
    }

    public int getHeartBeatPort() {
        return 0;
    }

    public boolean isUdpConnectRequest(Message connect) {
        return connect.headerExists("GDS_CLIENT_UDP_PORT");
    }

    public UdpReceiver newReceiver(AbstractChannel channel, HttpServletRequest request, Message connect) {
        Number port = (Number)connect.getHeader("GDS_CLIENT_UDP_PORT");
        InetSocketAddress address = new InetSocketAddress(request.getRemoteAddr(), port.intValue());
        log.debug("Creating UDP receiver for channel id %s and address %s", new Object[]{channel.getId(), address});
        return new UdpReceiverImpl(this.udpChannelFactory.newUdpChannel(channel, address), connect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.info("Stopping UDP Receiver Factory", new Object[0]);
        try {
            this.udpChannelFactory.stop();
        }
        finally {
            this.udpChannelFactory = null;
        }
    }
}

