/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.udp.AbstractUdpChannelFactory;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpIOChannel;
import org.granite.gravity.udp.UdpReceiverFactory;
import org.granite.logging.Logger;

public class UdpSharedIOChannelFactory
extends AbstractUdpChannelFactory {
    private static final Logger log = Logger.getLogger(UdpSharedIOChannelFactory.class);
    private DatagramSocket socket = null;

    public UdpSharedIOChannelFactory(UdpReceiverFactory factory) {
        super(factory);
    }

    @Override
    public void start() {
        super.start();
        int port = this.factory.getPort();
        if (port == 0) {
            log.info("Creating shared UDP socket on port * (any available port)...", new Object[0]);
        } else {
            log.info("Creating shared UDP socket on port %d...", new Object[]{port});
        }
        try {
            this.socket = new DatagramSocket(port);
            this.socket.setSendBufferSize(this.factory.getSendBufferSize());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data socket on port: " + port, e);
        }
        log.info("UDP shared socket bound to port: %d", new Object[]{this.socket.getLocalPort()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        log.info("Closing UDP socket...", new Object[0]);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                this.socket = null;
            }
        }
        log.info("UDP socket closed.", new Object[0]);
    }

    @Override
    public UdpChannel newUdpChannel(AbstractChannel gravityChannel, InetSocketAddress address) {
        return new UdpIOChannel(this, gravityChannel, this.socket, address);
    }
}

