/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpChannelFactory;

public abstract class AbstractUdpChannel
implements UdpChannel {
    protected UdpChannelFactory channelFactory = null;
    protected GravityInternal gravity = null;
    protected InetSocketAddress address = null;

    public AbstractUdpChannel(UdpChannelFactory channelFactory, GravityInternal gravity, InetSocketAddress address) {
        if (channelFactory == null || gravity == null) {
            throw new NullPointerException();
        }
        this.channelFactory = channelFactory;
        this.gravity = gravity;
        this.address = address;
    }

    @Override
    public GravityInternal getGravity() {
        return this.gravity;
    }

    @Override
    public int write(byte[] data) throws IOException {
        return this.write(data, 0, data.length);
    }

    @Override
    public void close() {
        this.channelFactory = null;
        this.gravity = null;
        this.address = null;
    }
}

