/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.udp.AbstractUdpChannelFactory;
import org.granite.gravity.udp.UdpChannel;
import org.granite.gravity.udp.UdpChannelFactory;
import org.granite.gravity.udp.UdpNIOChannel;
import org.granite.gravity.udp.UdpReceiverFactory;
import org.granite.logging.Logger;

public class UdpConnectedNIOChannelFactory
extends AbstractUdpChannelFactory {
    private static final Logger log = Logger.getLogger(UdpConnectedNIOChannelFactory.class);

    public UdpConnectedNIOChannelFactory(UdpReceiverFactory factory) {
        super(factory);
    }

    @Override
    public void start() {
        super.start();
        log.info("UDP channel factory started.", new Object[0]);
    }

    @Override
    public void stop() {
        super.stop();
        log.info("UDP channel factory stopped.", new Object[0]);
    }

    @Override
    public UdpChannel newUdpChannel(GravityInternal gravity, InetSocketAddress address) {
        int port = this.factory.getPort();
        if (port == 0) {
            log.info("Creating UDP channel on port * (any available port) and connected to %s...", new Object[]{address});
        } else {
            log.info("Creating UDP channel on port %d and connected to %s...", new Object[]{port, address});
        }
        try {
            DatagramChannel channel = DatagramChannel.open();
            channel.socket().setSendBufferSize(this.factory.getSendBufferSize());
            if (port != 0) {
                channel.socket().setReuseAddress(true);
            }
            channel.socket().bind(new InetSocketAddress(port));
            channel.connect(address);
            log.info("UDP channel bound to port %d and connected to %s", new Object[]{channel.socket().getLocalPort(), channel.socket().getRemoteSocketAddress()});
            return new UdpNIOChannel((UdpChannelFactory)this, gravity, channel);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data channel on port: " + port, e);
        }
    }
}

