/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.udp.AbstractUdpChannel;
import org.granite.gravity.udp.UdpChannelFactory;
import org.granite.gravity.udp.UdpPacketTooLargeException;

public class UdpIOChannel
extends AbstractUdpChannel {
    private DatagramSocket socket = null;

    public UdpIOChannel(UdpChannelFactory channelFactory, GravityInternal gravity, DatagramSocket socket) {
        this(channelFactory, gravity, socket, null);
    }

    public UdpIOChannel(UdpChannelFactory channelFactory, GravityInternal gravity, DatagramSocket socket, InetSocketAddress address) {
        super(channelFactory, gravity, address);
        if (address == null && !socket.isConnected() || address != null && socket.isConnected()) {
            throw new IllegalArgumentException("Inconsistent arguments");
        }
        this.socket = socket;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.socket.isConnected() ? this.socket.getRemoteSocketAddress() : this.address;
    }

    @Override
    public int getServerPort() {
        return this.socket.isConnected() ? this.socket.getLocalPort() : this.address.getPort();
    }

    @Override
    public int write(byte[] data, int offset, int length) throws IOException {
        int size = length - offset;
        if (size > 65536) {
            throw new UdpPacketTooLargeException("UDP packet size cannot exceed 64K: " + size);
        }
        DatagramPacket packet = this.socket.isConnected() ? new DatagramPacket(data, offset, length) : new DatagramPacket(data, offset, length, this.address);
        this.socket.send(packet);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            if (this.socket.isConnected()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }
}

