/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.udp;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.gravity.udp.UdpPacketTooLargeException;

public class UdpOutputStream
extends OutputStream {
    private static final int MAX_SIZE = 65536;
    private byte[] buffer = new byte[512];
    private int size = 0;

    @Override
    public void write(int b) throws IOException {
        if (this.size >= this.buffer.length) {
            if (this.size >= 65536) {
                throw new UdpPacketTooLargeException("Max capacity of 64K reached");
            }
            byte[] newBuffer = new byte[this.buffer.length << 1];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.size++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newSize = len + this.size;
        if (newSize > 65536) {
            throw new UdpPacketTooLargeException("Max capacity of 64K reached");
        }
        if (newSize > this.buffer.length) {
            int newCapacity;
            for (newCapacity = this.buffer.length << 1; newCapacity < newSize; newCapacity <<= 1) {
            }
            byte[] newBuffer = new byte[newCapacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        System.arraycopy(b, off, this.buffer, this.size, len);
        this.size = newSize;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

