/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import java.util.logging.Level;
import org.granite.logging.Logger;
import org.granite.logging.LoggingFormatter;

public class JdkLogger
extends Logger {
    public JdkLogger(String name, LoggingFormatter formatter) {
        super(java.util.logging.Logger.getLogger(name), formatter);
    }

    @Override
    protected java.util.logging.Logger getLoggerImpl() {
        return (java.util.logging.Logger)super.getLoggerImpl();
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(Level.INFO, this.getFormatter().format(message, args));
        }
    }

    @Override
    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(Level.INFO, this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(Level.FINER, this.getFormatter().format(message, args));
        }
    }

    @Override
    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(Level.FINER, this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(Level.WARNING, this.getFormatter().format(message, args));
        }
    }

    @Override
    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(Level.WARNING, this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(Level.FINE, this.getFormatter().format(message, args));
        }
    }

    @Override
    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(Level.FINE, this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(Level.SEVERE, this.getFormatter().format(message, args));
        }
    }

    @Override
    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(Level.SEVERE, this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLoggerImpl().isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLoggerImpl().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLoggerImpl().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLoggerImpl().isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLoggerImpl().isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLoggerImpl().isLoggable(Level.WARNING);
    }
}

