/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.granite.logging.Logger;
import org.granite.logging.LoggingFormatter;

public class Log4jLogger
extends Logger {
    private static final String FQCN = Log4jLogger.class.getName();

    public Log4jLogger(String name, LoggingFormatter formatter) {
        super(LogManager.getLogger((String)name), formatter);
    }

    protected org.apache.log4j.Logger getLoggerImpl() {
        return (org.apache.log4j.Logger)super.getLoggerImpl();
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.INFO, (Object)this.getFormatter().format(message, args), null);
        }
    }

    @Override
    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.INFO, (Object)this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.TRACE, (Object)this.getFormatter().format(message, args), null);
        }
    }

    @Override
    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.TRACE, (Object)this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.WARN, (Object)this.getFormatter().format(message, args), null);
        }
    }

    @Override
    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.WARN, (Object)this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.DEBUG, (Object)this.getFormatter().format(message, args), null);
        }
    }

    @Override
    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.DEBUG, (Object)this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.ERROR, (Object)this.getFormatter().format(message, args), null);
        }
    }

    @Override
    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(FQCN, (Priority)Level.ERROR, (Object)this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLoggerImpl().isEnabledFor((Priority)Level.WARN);
    }
}

