/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.ClassCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

public class ClassCodecImpl
extends AbstractIntegerStringCodec<Object>
implements ClassCodec {
    protected static final AbstractIntegerStringCodec.StringTypeHandler TYPE_HANDLER = new AbstractIntegerStringCodec.StringTypeHandler(){

        @Override
        public int type(AbstractIntegerStringCodec.IntegerComponents ics, boolean reference) {
            return reference ? 0x40 | ics.length << 4 | 0 : ics.length << 4 | 0;
        }

        @Override
        public int indexOrLengthBytesCount(int parameterizedJmfType) {
            return parameterizedJmfType >> 4 & 3;
        }

        @Override
        public boolean isReference(int parameterizedJmfType) {
            return (parameterizedJmfType & 0x40) != 0;
        }
    };

    @Override
    public int getObjectType() {
        return 0;
    }

    @Override
    public boolean canEncode(Object v) {
        return v instanceof Class;
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException, IllegalAccessException {
        this.writeString(ctx, ctx.getAlias(((Class)v).getName()), TYPE_HANDLER);
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 0) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        String className = this.readString(ctx, parameterizedJmfType, TYPE_HANDLER);
        className = ctx.getAlias(className);
        return ctx.getReflection().loadClass(className);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 0) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        String className = this.readString(ctx, parameterizedJmfType, TYPE_HANDLER);
        className = ctx.getAlias(className);
        ctx.indentPrintLn(Class.class.getName() + ": " + className + ".class");
    }
}

