/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.FloatCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class FloatCodecImpl
extends AbstractStandardCodec<Float>
implements FloatCodec {
    @Override
    public int getObjectType() {
        return 125;
    }

    @Override
    public Class<?> getObjectClass() {
        return Float.class;
    }

    @Override
    public int getPrimitiveType() {
        return 124;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Float.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Float v) throws IOException {
        FloatCodecImpl.writeFloatData(ctx, 125, v.floatValue());
    }

    @Override
    public Float decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 125) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return Float.valueOf(FloatCodecImpl.readFloatData(ctx, parameterizedJmfType));
    }

    @Override
    public void encodePrimitive(OutputContext ctx, float v) throws IOException {
        FloatCodecImpl.writeFloatData(ctx, 124, v);
    }

    @Override
    public float decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 124) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return FloatCodecImpl.readFloatData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 124: {
                ctx.indentPrintLn("float: " + FloatCodecImpl.readFloatData(ctx, parameterizedJmfType));
                break;
            }
            case 125: {
                ctx.indentPrintLn(Float.class.getName() + ": " + Float.valueOf(FloatCodecImpl.readFloatData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    public static void writeFloatData(OutputContext ctx, int jmfType, float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        OutputStream os = ctx.getOutputStream();
        os.write(jmfType);
        os.write(bits);
        os.write(bits >> 8);
        os.write(bits >> 16);
        os.write(bits >> 24);
    }

    public static float readFloatData(InputContext ctx, int type) throws IOException {
        int i = ctx.safeRead();
        i |= ctx.safeRead() << 8;
        i |= ctx.safeRead() << 16;
        return Float.intBitsToFloat(i |= ctx.safeRead() << 24);
    }
}

