/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.granite.logging.Logger;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.AbstractTidePersistenceManager;
import org.granite.tide.data.JPATransactionManager;
import org.granite.tide.data.TideTransactionPersistenceManager;
import org.granite.util.Entity;

public class JPAPersistenceManager
extends AbstractTidePersistenceManager
implements TideTransactionPersistenceManager {
    private static final Logger log = Logger.getLogger(JPAPersistenceManager.class);
    protected EntityManager entityManager;
    protected EntityManagerFactory entityManagerFactory;
    protected boolean shouldCloseEntityManager = false;

    public JPAPersistenceManager(TideTransactionManager tm) {
        super(tm);
    }

    public JPAPersistenceManager(EntityManager em) {
        this(em, null);
    }

    public JPAPersistenceManager(EntityManager em, TideTransactionManager tm) {
        super(tm != null ? tm : new JPATransactionManager());
        if (em == null) {
            throw new RuntimeException("entity manager cannot be null");
        }
        this.entityManager = em;
    }

    public JPAPersistenceManager(EntityManagerFactory emf) {
        this(emf, null);
    }

    public JPAPersistenceManager(EntityManagerFactory emf, TideTransactionManager tm) {
        super(tm != null ? tm : new JPATransactionManager());
        if (emf == null) {
            throw new RuntimeException("entity manager factory cannot be null");
        }
        this.entityManagerFactory = emf;
    }

    @Override
    public Object getCurrentTransaction() {
        this.initEntityManager();
        EntityTransaction et = this.entityManager.getTransaction();
        et.begin();
        return et;
    }

    protected void initEntityManager() {
        if (this.entityManager != null) {
            return;
        }
        this.entityManager = this.entityManagerFactory.createEntityManager();
        this.shouldCloseEntityManager = true;
    }

    @Override
    public void close() {
        if (this.shouldCloseEntityManager && this.entityManager != null) {
            this.entityManager.close();
        }
    }

    @Override
    public Object fetchEntity(Object entity, String[] fetch) {
        Entity tideEntity = new Entity(entity);
        Serializable id = (Serializable)tideEntity.getIdentifier();
        if (id == null) {
            return null;
        }
        this.initEntityManager();
        if (fetch == null || this.entityManager.getDelegate().getClass().getName().indexOf(".hibernate.") < 0) {
            return this.entityManager.find(entity.getClass(), (Object)id);
        }
        for (String f : fetch) {
            Query q = this.entityManager.createQuery("select e from " + entity.getClass().getName() + " e left join fetch e." + f + " where e = :entity");
            q.setParameter("entity", entity);
            List results = q.getResultList();
            if (!results.isEmpty()) {
                entity = results.get(0);
                continue;
            }
            log.warn("Could not find entity %s to initialize, id: %s", entity.getClass().getName(), id);
        }
        return entity;
    }
}

