/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.granite.util.TypeUtil;

public class CollectionUtil {
    public static Type getComponentType(Type collectionType) {
        Type[] componentTypes;
        Class<?> collectionClass = TypeUtil.classOfType(collectionType);
        if (collectionClass == null || !Collection.class.isAssignableFrom(collectionClass)) {
            return null;
        }
        if (collectionType instanceof ParameterizedType && (componentTypes = ((ParameterizedType)collectionType).getActualTypeArguments()) != null && componentTypes.length == 1) {
            return componentTypes[0];
        }
        return Object.class;
    }

    public static Collection<Object> newCollection(Class<?> targetClass, int length) throws InstantiationException, IllegalAccessException {
        if (targetClass.isInterface()) {
            if (Set.class.isAssignableFrom(targetClass)) {
                if (SortedSet.class.isAssignableFrom(targetClass)) {
                    return new TreeSet<Object>();
                }
                return new HashSet<Object>(length);
            }
            if (targetClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList<Object>(length);
            }
            throw new IllegalArgumentException("Unsupported collection interface: " + targetClass);
        }
        return (Collection)targetClass.newInstance();
    }
}

