/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.granite.logging.Logger;

public class ServletParams {
    private static final Logger log = Logger.getLogger(ServletParams.class);

    public static <T> T get(ServletContext context, String name, Class<T> clazz, T defaultValue) {
        return ServletParams.get(context, name, clazz, defaultValue, false, true);
    }

    public static <T> T get(ServletConfig config, String name, Class<T> clazz, T defaultValue) {
        return ServletParams.get(config, name, clazz, defaultValue, false, true);
    }

    public static <T> T get(FilterConfig config, String name, Class<T> clazz, T defaultValue) {
        return ServletParams.get(config, name, clazz, defaultValue, false, true);
    }

    public static <T> T get(final ServletContext context, final String name, Class<T> clazz, T defaultValue, boolean required, boolean warn) {
        ParamGetter getter = new ParamGetter(){

            @Override
            public Enumeration<String> getNames() {
                return context.getInitParameterNames();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return context.getInitParameter(name);
            }
        };
        return ServletParams.getInitParameter(getter, clazz, defaultValue, required, warn);
    }

    public static <T> T get(final ServletConfig config, final String name, Class<T> clazz, T defaultValue, boolean required, boolean warn) {
        ParamGetter getter = new ParamGetter(){

            @Override
            public Enumeration<String> getNames() {
                return config.getInitParameterNames();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return config.getInitParameter(name);
            }
        };
        return ServletParams.getInitParameter(getter, clazz, defaultValue, required, warn);
    }

    public static <T> T get(final FilterConfig config, final String name, Class<T> clazz, T defaultValue, boolean required, boolean warn) {
        ParamGetter getter = new ParamGetter(){

            @Override
            public Enumeration<String> getNames() {
                return config.getInitParameterNames();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return config.getInitParameter(name);
            }
        };
        return ServletParams.getInitParameter(getter, clazz, defaultValue, required, warn);
    }

    public static boolean contains(FilterConfig config, String name) {
        boolean found = false;
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (!name.equals(n)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean contains(ServletConfig config, String name) {
        boolean found = false;
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (!name.equals(n)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean contains(ServletContext context, String name) {
        boolean found = false;
        Enumeration e = context.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (!name.equals(n)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static <T> T getInitParameter(ParamGetter getter, Class<T> clazz, T defaultValue, boolean required, boolean warn) {
        boolean unsupported;
        Object oValue;
        block24: {
            if (required) {
                boolean found = false;
                Enumeration<String> e = getter.getNames();
                while (e.hasMoreElements()) {
                    String name = e.nextElement();
                    if (!name.equals(getter.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new RuntimeException("Init parameter " + getter.getName() + " is required in web.xml");
                }
            }
            String sValue = getter.getValue();
            oValue = defaultValue;
            unsupported = false;
            if (sValue != null) {
                try {
                    if (clazz == String.class) {
                        oValue = sValue;
                    } else if (clazz == Integer.class || clazz == Integer.TYPE) {
                        oValue = Integer.valueOf(sValue);
                    } else if (clazz == Long.class || clazz == Long.TYPE) {
                        oValue = Long.valueOf(sValue);
                    } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                        if (!Boolean.TRUE.toString().equalsIgnoreCase(sValue) && !Boolean.FALSE.toString().equalsIgnoreCase(sValue)) {
                            throw new NumberFormatException(sValue);
                        }
                        oValue = Boolean.valueOf(sValue);
                    } else if (clazz == Double.class || clazz == Double.TYPE) {
                        oValue = Double.valueOf(sValue);
                    } else if (clazz == Float.class || clazz == Float.TYPE) {
                        oValue = Float.valueOf(sValue);
                    } else if (clazz == Short.class || clazz == Short.TYPE) {
                        oValue = Short.valueOf(sValue);
                    } else if (clazz == Byte.class || clazz == Byte.TYPE) {
                        oValue = Byte.valueOf(sValue);
                    } else {
                        unsupported = true;
                    }
                }
                catch (Exception e) {
                    if (!warn) break block24;
                    log.warn(e, "Illegal %s value for %s: %s (using default: %s)", clazz.getSimpleName(), getter.getName(), sValue, defaultValue);
                }
            }
        }
        if (unsupported) {
            throw new UnsupportedOperationException("Unsupported value type: " + clazz.getName());
        }
        T tValue = oValue;
        return tValue;
    }

    private static interface ParamGetter {
        public Enumeration<String> getNames();

        public String getName();

        public String getValue();
    }
}

