/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.weblogic;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.GravityServletUtil;
import org.granite.gravity.weblogic.WebLogicChannel;
import org.granite.gravity.weblogic.WebLogicChannelFactory;
import org.granite.logging.Logger;
import org.granite.util.ServletParams;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class GravityWebLogicServlet
extends AbstractAsyncServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityWebLogicServlet.class);
    private static final String SCAVANGE_INTERVAL = "scavangeInterval";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        GravityServletUtil.init(config);
        int scavangeInterval = ServletParams.get(config, SCAVANGE_INTERVAL, Integer.TYPE, Integer.valueOf(40000));
        log.info("Using scavange interval of: %s", scavangeInterval);
        AbstractAsyncServlet.setScavangeInterval((int)scavangeInterval);
    }

    protected boolean doRequest(RequestResponseKey key) throws IOException, ServletException {
        HttpServletRequest request = key.getRequest();
        HttpServletResponse response = key.getResponse();
        GravityServletUtil.rejectJMFContentType(request);
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        WebLogicChannelFactory channelFactory = new WebLogicChannelFactory(gravity);
        try {
            GravityServletUtil.initializeRequest(this.getServletConfig(), gravity, request, response);
            Message[] amf3Requests = GravityServletUtil.deserialize(gravity, request);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one connect request is allowed on tunnel.");
                    }
                    WebLogicChannel channel = gravity.getChannel(channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        boolean bl = false;
                        return bl;
                    }
                    GravityServletUtil.setConnectMessage(request, amf3Request);
                    key.setTimeout((int)GravityServletUtil.getLongPollingTimeout(this.getServletContext()));
                    channel.setRequestResponseKey(key);
                    boolean bl = true;
                    return bl;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            GravityServletUtil.serialize(gravity, response, amf3Responses);
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            GravityServletUtil.cleanupRequest(request);
        }
        return false;
    }

    protected void doResponse(RequestResponseKey key, Object context) throws IOException, ServletException {
        WebLogicChannel channel = (WebLogicChannel)context;
        HttpServletRequest request = key.getRequest();
        HttpServletResponse response = key.getResponse();
        CommandMessage requestMessage = AbstractGravityServlet.getConnectMessage(request);
        channel.runReceived(new AsyncHttpContext(request, response, requestMessage));
    }

    protected void doTimeout(RequestResponseKey key) throws IOException, ServletException {
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        WebLogicChannelFactory channelFactory = new WebLogicChannelFactory(gravity);
        CommandMessage amf3Request = GravityServletUtil.getConnectMessage(key.getRequest());
        String channelId = (String)amf3Request.getClientId();
        WebLogicChannel channel = gravity.getChannel(channelFactory, channelId);
        channel.setRequestResponseKey(null);
    }
}

