/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.TypeUtil;

public class Date2Date
extends Converter {
    public Date2Date(Converters converters) {
        super(converters);
    }

    @Override
    protected boolean internalCanConvert(Object value, Type targetType) {
        Class<Comparable<Date>> targetClass = TypeUtil.classOfType(targetType);
        return !(!targetClass.isAssignableFrom(Date.class) && !targetClass.isAssignableFrom(Calendar.class) && !targetClass.isAssignableFrom(Timestamp.class) && !targetClass.isAssignableFrom(Time.class) && !targetClass.isAssignableFrom(java.sql.Date.class) || value != null && !(value instanceof Date));
    }

    @Override
    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        Date date = (Date)value;
        Class<Comparable<Date>> targetClass = TypeUtil.classOfType(targetType);
        if (targetClass.isAssignableFrom(Date.class)) {
            return value;
        }
        if (targetClass.isAssignableFrom(Calendar.class)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        if (targetClass.isAssignableFrom(Timestamp.class)) {
            return new Timestamp(date.getTime());
        }
        if (targetClass.isAssignableFrom(java.sql.Date.class)) {
            return new java.sql.Date(date.getTime());
        }
        if (targetClass.isAssignableFrom(Time.class)) {
            return new Time(date.getTime());
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

