/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;

public class String2CharArray
extends Converter {
    public String2CharArray(Converters converters) {
        super(converters);
    }

    @Override
    protected boolean internalCanConvert(Object value, Type targetType) {
        if (targetType instanceof Class) {
            Class targetClass = (Class)targetType;
            return !(!targetClass.isArray() || !targetClass.getComponentType().equals(Character.TYPE) && !targetClass.getComponentType().equals(Character.class) || value != null && !(value instanceof String));
        }
        return false;
    }

    @Override
    protected Object internalConvert(Object value, Type targetType) {
        if (value == null) {
            return null;
        }
        Class<?> componentType = ((Class)targetType).getComponentType();
        if (componentType.equals(Character.TYPE)) {
            return ((String)value).toCharArray();
        }
        if (componentType.equals(Character.class)) {
            String s = (String)value;
            Object array = Array.newInstance(Character.class, s.length());
            for (int i = 0; i < s.length(); ++i) {
                Array.set(array, i, Character.valueOf(s.charAt(i)));
            }
            return array;
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

