/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.messaging.AliasRegistry;
import org.granite.messaging.DefaultAliasRegistry;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DefaultCodecRegistry;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.reflect.Reflection;

public class DefaultSharedContext
implements SharedContext {
    protected static List<String> JAVA_DEFAULT_STORED_STRINGS = Arrays.asList(Boolean.class.getName(), Character.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), Object.class.getName(), Date.class.getName(), List.class.getName(), ArrayList.class.getName(), Set.class.getName(), HashSet.class.getName(), Map.class.getName(), HashMap.class.getName(), "org.granite.client.persistence.collection.PersistentList", "org.granite.client.persistence.collection.PersistentMap", "org.granite.client.persistence.collection.PersistentSet", "org.granite.client.persistence.collection.PersistentBag", "org.granite.client.persistence.collection.PersistentSortedSet", "org.granite.client.persistence.collection.PersistentSortedMap");
    protected final CodecRegistry codecRegistry;
    protected final Reflection reflection;
    protected final List<String> defaultStoredStrings;
    protected final AliasRegistry aliasRegistry;

    public DefaultSharedContext() {
        this(null, null, null, null);
    }

    public DefaultSharedContext(CodecRegistry codecRegistry) {
        this(codecRegistry, null, null, null);
    }

    public DefaultSharedContext(CodecRegistry codecRegistry, List<String> defaultStoredStrings) {
        this(codecRegistry, defaultStoredStrings, null, null);
    }

    public DefaultSharedContext(CodecRegistry codecRegistry, List<String> defaultStoredStrings, Reflection reflection, AliasRegistry aliasRegistry) {
        this.codecRegistry = codecRegistry != null ? codecRegistry : new DefaultCodecRegistry();
        ArrayList<String> defaultStoredStringsTmp = new ArrayList<String>(JAVA_DEFAULT_STORED_STRINGS);
        if (defaultStoredStrings != null) {
            defaultStoredStringsTmp.addAll(defaultStoredStrings);
        }
        this.defaultStoredStrings = Collections.unmodifiableList(defaultStoredStringsTmp);
        this.reflection = reflection != null ? reflection : new Reflection(null);
        this.aliasRegistry = aliasRegistry != null ? aliasRegistry : new DefaultAliasRegistry();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public Reflection getReflection() {
        return this.reflection;
    }

    @Override
    public List<String> getDefaultStoredStrings() {
        return this.defaultStoredStrings;
    }

    @Override
    public AliasRegistry getAliasRegistry() {
        return this.aliasRegistry;
    }

    @Override
    public String getRemoteAlias(String className) {
        return this.aliasRegistry.getAliasForType(className);
    }

    @Override
    public String getClassName(String remoteAlias) {
        return this.aliasRegistry.getTypeForAlias(remoteAlias);
    }
}

