/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.Reflection;

public class JMFSerializer
implements OutputContext {
    protected final Map<String, Integer> storedStrings = new HashMap<String, Integer>(256);
    protected final Map<Object, Integer> storedObjects = new IdentityHashMap<Object, Integer>(256);
    protected final OutputStream outputStream;
    protected final SharedContext context;
    protected final CodecRegistry codecRegistry;

    public JMFSerializer(OutputStream outputStream, SharedContext context) {
        this.outputStream = outputStream;
        this.codecRegistry = context.getCodecRegistry();
        this.context = context;
        for (String s : context.getDefaultStoredStrings()) {
            this.addToStoredStrings(s);
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.codecRegistry.getBooleanCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.codecRegistry.getByteCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.codecRegistry.getShortCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.codecRegistry.getCharacterCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.codecRegistry.getIntegerCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.codecRegistry.getLongCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.codecRegistry.getFloatCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.codecRegistry.getDoubleCodec().encodePrimitive(this, v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.codecRegistry.getNullCodec().encode((OutputContext)this, s);
        } else {
            this.codecRegistry.getStringCodec().encode((OutputContext)this, s);
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        StandardCodec<Object> codec = this.codecRegistry.getCodec(obj);
        if (codec == null) {
            throw new JMFEncodingException("Unsupported Java class: " + obj);
        }
        try {
            codec.encode(this, obj);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    @Deprecated
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException("Use writeByte(b)");
    }

    @Override
    @Deprecated
    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException("Use writeObject(b)");
    }

    @Override
    @Deprecated
    public void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Use writeObject(Arrays.copyOfRange(b, off, off+len))");
    }

    @Override
    @Deprecated
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException("Use writeUTF(s)");
    }

    @Override
    @Deprecated
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException("Use writeUTF(s)");
    }

    @Override
    public SharedContext getSharedContext() {
        return this.context;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void addToStoredStrings(String s) {
        if (s != null && !this.storedStrings.containsKey(s)) {
            Integer index = this.storedStrings.size();
            this.storedStrings.put(s, index);
        }
    }

    @Override
    public int indexOfStoredStrings(String s) {
        Integer index;
        if (s != null && (index = this.storedStrings.get(s)) != null) {
            return index;
        }
        return -1;
    }

    @Override
    public void addToStoredObjects(Object o) {
        if (o != null && !this.storedObjects.containsKey(o)) {
            Integer index = this.storedObjects.size();
            this.storedObjects.put(o, index);
        }
    }

    @Override
    public int indexOfStoredObjects(Object o) {
        Integer index;
        if (o != null && (index = this.storedObjects.get(o)) != null) {
            return index;
        }
        return -1;
    }

    @Override
    public Reflection getReflection() {
        return this.context.getReflection();
    }

    @Override
    public String getAlias(String className) {
        return this.context.getRemoteAlias(className);
    }

    @Override
    public void getAndWriteProperty(Object obj, Property property) throws IOException, IllegalAccessException, InvocationTargetException {
        if (property.getType().isPrimitive()) {
            this.codecRegistry.getPrimitivePropertyCodec(property.getType()).encodePrimitive(this, obj, property);
        } else {
            this.writeObject(property.getObject(obj));
        }
    }
}

