/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.persistence;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.persistence.AbstractExternalizablePersistentCollection;
import org.granite.util.TypeUtil;

public class ExternalizablePersistentMap
extends AbstractExternalizablePersistentCollection {
    private static final long serialVersionUID = 1L;

    public ExternalizablePersistentMap() {
    }

    public ExternalizablePersistentMap(Map<?, ?> content, boolean initialized, boolean dirty) {
        super(null, initialized, dirty);
        this.setContentFromMap(content);
    }

    public ExternalizablePersistentMap(Object[] content, boolean initialized, boolean dirty) {
        super(content, initialized, dirty);
    }

    public Map<?, ?> getContentAsMap(Type target) {
        return this.getContentAsMap(target, null);
    }

    public Map<?, ?> getContentAsMap(Type target, Comparator comparator) {
        AbstractMap map = null;
        if (this.content != null) {
            map = SortedMap.class.isAssignableFrom(TypeUtil.classOfType(target)) ? (comparator != null ? new TreeMap(comparator) : new TreeMap()) : new HashMap(this.content.length);
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            Type[] typeArguments = null;
            if (target instanceof ParameterizedType) {
                typeArguments = ((ParameterizedType)target).getActualTypeArguments();
            }
            for (int i = 0; i < this.content.length; ++i) {
                Object[] entry = (Object[])this.content[i];
                if (typeArguments != null) {
                    map.put(converters.convert(entry[0], typeArguments[0]), converters.convert(entry[1], typeArguments[1]));
                    continue;
                }
                map.put(entry[0], entry[1]);
            }
        }
        return map;
    }

    public void setContentFromMap(Map<?, ?> map) {
        if (map == null) {
            this.content = null;
        } else {
            this.content = new Object[map.size()];
            int index = 0;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.content[index++] = new Object[]{entry.getKey(), entry.getValue()};
            }
        }
    }
}

