/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.messaging.annotations.Exclude;
import org.granite.messaging.annotations.Include;
import org.granite.messaging.annotations.Serialized;
import org.granite.messaging.reflect.BypassConstructorAllocator;
import org.granite.messaging.reflect.FieldProperty;
import org.granite.messaging.reflect.MethodProperty;
import org.granite.messaging.reflect.NullProperty;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.ReflectionException;
import org.granite.messaging.reflect.SimpleFieldProperty;
import org.granite.messaging.reflect.SimpleMethodProperty;
import org.granite.messaging.reflect.SunBypassConstructorAllocator;

public class Reflection {
    protected static final int STATIC_TRANSIENT_MASK = 136;
    protected static final int STATIC_PRIVATE_PROTECTED_MASK = 14;
    protected static final Property NULL_PROPERTY = new NullProperty();
    protected final ClassLoader classLoader;
    protected final BypassConstructorAllocator instanceFactory;
    protected final Comparator<Property> lexicalPropertyComparator;
    protected final ConcurrentMap<Class<?>, List<Property>> serializablePropertiesCache;
    protected final ConcurrentMap<SinglePropertyKey, Property> singlePropertyCache;

    public Reflection(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public Reflection(ClassLoader classLoader, BypassConstructorAllocator instanceFactory) {
        this.classLoader = classLoader;
        if (instanceFactory != null) {
            this.instanceFactory = instanceFactory;
        } else {
            try {
                this.instanceFactory = new SunBypassConstructorAllocator();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate BypassConstructorAllocator", e);
            }
        }
        this.lexicalPropertyComparator = new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                return p1.getName().compareTo(p2.getName());
            }
        };
        this.serializablePropertiesCache = new ConcurrentHashMap();
        this.singlePropertyCache = new ConcurrentHashMap<SinglePropertyKey, Property>();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    public <T> T newInstance(Class<T> cls) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        try {
            Constructor<T> constructor = cls.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return this.instanceFactory.newInstance(cls);
        }
    }

    public <T> T newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return (T)this.newInstance(this.loadClass(className));
    }

    public Property findSerializableProperty(Class<?> cls, String name) throws SecurityException {
        List<Property> properties = this.findSerializableProperties(cls);
        for (Property property : properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public List<Property> findSerializableProperties(Class<?> cls) throws SecurityException {
        List<Property> serializableProperties = (ArrayList)this.serializablePropertiesCache.get(cls);
        if (serializableProperties == null) {
            ArrayList hierarchy = new ArrayList();
            for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                hierarchy.add(c);
            }
            serializableProperties = new ArrayList();
            for (int i = hierarchy.size() - 1; i >= 0; --i) {
                Class c = (Class)hierarchy.get(i);
                serializableProperties.addAll(this.findSerializableDeclaredProperties(c));
            }
            List previous = this.serializablePropertiesCache.putIfAbsent(cls, serializableProperties = Collections.unmodifiableList(serializableProperties));
            if (previous != null) {
                serializableProperties = previous;
            }
        }
        return serializableProperties;
    }

    protected FieldProperty newFieldProperty(Field field) {
        return new SimpleFieldProperty(field);
    }

    protected MethodProperty newMethodProperty(Method getter, Method setter, String name) {
        return new SimpleMethodProperty(getter, setter, name);
    }

    protected List<Property> findSerializableDeclaredProperties(Class<?> cls) throws SecurityException {
        Method[] declaredMethods;
        if (!this.isRegularClass(cls)) {
            throw new IllegalArgumentException("Not a regular class: " + cls);
        }
        Field[] declaredFields = cls.getDeclaredFields();
        ArrayList<Property> serializableProperties = new ArrayList<Property>(declaredFields.length);
        for (Field field : declaredFields) {
            int modifiers = field.getModifiers();
            if ((modifiers & 0x88) != 0 || field.isAnnotationPresent(Exclude.class)) continue;
            field.setAccessible(true);
            serializableProperties.add(this.newFieldProperty(field));
        }
        for (Method method : declaredMethods = cls.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if ((modifiers & 0xE) != 0 || !method.isAnnotationPresent(Include.class) || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                if (name.length() <= 3) continue;
                name = name.substring(3, 4).toLowerCase() + name.substring(4);
            } else {
                if (!name.startsWith("is") || method.getReturnType() != Boolean.class && method.getReturnType() != Boolean.TYPE || name.length() <= 2) continue;
                name = name.substring(2, 3).toLowerCase() + name.substring(3);
            }
            serializableProperties.add(this.newMethodProperty(method, null, name));
        }
        Serialized serialized = cls.getAnnotation(Serialized.class);
        if (serialized != null && serialized.propertiesOrder().length > 0) {
            String[] value = serialized.propertiesOrder();
            if (value.length != serializableProperties.size()) {
                throw new ReflectionException("Illegal @Serialized(propertiesOrder) value: " + serialized + " on: " + cls.getName() + " (bad length)");
            }
            for (int i = 0; i < value.length; ++i) {
                String propertyName = value[i];
                boolean found = false;
                for (int j = i; j < value.length; ++j) {
                    Property property = (Property)serializableProperties.get(j);
                    if (!property.getName().equals(propertyName)) continue;
                    found = true;
                    if (i == j) break;
                    serializableProperties.set(j, (Property)serializableProperties.get(i));
                    serializableProperties.set(i, property);
                    break;
                }
                if (found) continue;
                throw new ReflectionException("Illegal @Serialized(propertiesOrder) value: " + serialized + " on: " + cls.getName() + " (\"" + propertyName + "\" isn't a property name)");
            }
        } else {
            Collections.sort(serializableProperties, this.lexicalPropertyComparator);
        }
        return serializableProperties;
    }

    public boolean isRegularClass(Class<?> cls) {
        return cls != Class.class && !cls.isAnnotation() && !cls.isArray() && !cls.isEnum() && !cls.isInterface() && !cls.isPrimitive();
    }

    public Property findProperty(Class<?> cls, String name, Class<?> type) {
        NameTypePropertyKey key = new NameTypePropertyKey(cls, name, type);
        Property property = (Property)this.singlePropertyCache.get(key);
        if (property == null) {
            Property previous;
            Field field = null;
            for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                try {
                    field = c.getDeclaredField(name);
                }
                catch (Exception e) {
                    continue;
                }
                if (field.getType() != type) continue;
                field.setAccessible(true);
                break;
            }
            if ((previous = this.singlePropertyCache.putIfAbsent(key, property = field == null ? NULL_PROPERTY : this.newFieldProperty(field))) != null) {
                property = previous;
            }
        }
        return property != NULL_PROPERTY ? property : null;
    }

    public Property findProperty(Class<?> cls, Class<? extends Annotation> annotationClass) {
        AnnotatedPropertyKey key = new AnnotatedPropertyKey(cls, annotationClass);
        Property property = (Property)this.singlePropertyCache.get(key);
        if (property == null) {
            Property previous;
            boolean searchFields = false;
            boolean searchMethods = false;
            if (!annotationClass.isAnnotationPresent(Target.class)) {
                searchMethods = true;
                searchFields = true;
            } else {
                Target target = annotationClass.getAnnotation(Target.class);
                for (ElementType targetType : target.value()) {
                    if (targetType == ElementType.FIELD) {
                        searchFields = true;
                        continue;
                    }
                    if (targetType != ElementType.METHOD) continue;
                    searchMethods = true;
                }
            }
            if (!searchFields && !searchMethods) {
                return null;
            }
            int modifierMask = 9;
            block7: for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                if (searchMethods) {
                    for (Method method : c.getDeclaredMethods()) {
                        String name;
                        if ((method.getModifiers() & 9) != 1 || !method.isAnnotationPresent(annotationClass)) continue;
                        if (method.getReturnType() == Void.TYPE) {
                            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || (name = method.getName().substring(3)).length() == 0) continue;
                            Method getter = null;
                            try {
                                getter = cls.getMethod("get" + name, new Class[0]);
                            }
                            catch (Exception e) {
                                try {
                                    getter = cls.getMethod("is" + name, new Class[0]);
                                }
                                catch (Exception f) {
                                    // empty catch block
                                }
                            }
                            if (getter != null && (getter.getModifiers() & 8) != 0 && getter.getReturnType() != method.getParameterTypes()[0]) {
                                getter = null;
                            }
                            if (getter == null) continue;
                            name = name.substring(0, 1).toLowerCase() + name.substring(1);
                            property = this.newMethodProperty(getter, method, name);
                            break block7;
                        }
                        if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || (name = method.getName().startsWith("get") ? method.getName().substring(3) : method.getName().substring(2)).length() == 0) continue;
                        Method setter = null;
                        try {
                            setter = cls.getMethod("set" + name, new Class[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (setter != null && (setter.getModifiers() & 8) != 0 && method.getReturnType() != setter.getParameterTypes()[0]) {
                            setter = null;
                        }
                        name = name.substring(0, 1).toLowerCase() + name.substring(1);
                        property = this.newMethodProperty(method, setter, name);
                        break block7;
                    }
                }
                if (!searchFields) continue;
                for (Field field : c.getDeclaredFields()) {
                    if ((field.getModifiers() & 8) != 0 || !field.isAnnotationPresent(annotationClass)) continue;
                    property = this.newFieldProperty(field);
                    break block7;
                }
            }
            if (property == null) {
                property = NULL_PROPERTY;
            }
            if ((previous = this.singlePropertyCache.putIfAbsent(key, property)) != null) {
                property = previous;
            }
        }
        return property != NULL_PROPERTY ? property : null;
    }

    protected static class NameTypePropertyKey
    implements SinglePropertyKey {
        private final Class<?> cls;
        private final String name;
        private final Class<?> type;

        public NameTypePropertyKey(Class<?> cls, String name, Class<?> type) {
            this.cls = cls;
            this.name = name;
            this.type = type;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int hashCode() {
            return this.cls.hashCode() + this.name.hashCode() + this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NameTypePropertyKey)) {
                return false;
            }
            NameTypePropertyKey key = (NameTypePropertyKey)obj;
            return this.cls.equals(key.cls) && this.name.equals(key.name) && this.type.equals(key.type);
        }
    }

    protected static class AnnotatedPropertyKey
    implements SinglePropertyKey {
        private final Class<?> cls;
        private final Class<? extends Annotation> annotationClass;

        public AnnotatedPropertyKey(Class<?> cls, Class<? extends Annotation> annotationClass) {
            this.cls = cls;
            this.annotationClass = annotationClass;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public int hashCode() {
            return this.cls.hashCode() + this.annotationClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AnnotatedPropertyKey)) {
                return false;
            }
            AnnotatedPropertyKey key = (AnnotatedPropertyKey)obj;
            return this.cls.equals(key.cls) && this.annotationClass.equals(key.annotationClass);
        }
    }

    protected static interface SinglePropertyKey {
    }
}

