/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import weblogic.servlet.security.ServletAuthentication;

public class WebLogicSecurityService
extends AbstractSecurityService {
    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = context.getRequest();
        HttpServletResponse httpResponse = context.getResponse();
        int result = 1;
        try {
            result = ServletAuthentication.login((String)decoded[0], (String)decoded[1], (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
        catch (LoginException e) {
            // empty catch block
        }
        if (result != 0) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        httpRequest.getSession(true);
        this.endLogin(credentials, charset);
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        if (context.getDestination().isSecured()) {
            HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            HttpServletRequest httpRequest = graniteContext.getRequest();
            Principal principal = httpRequest.getUserPrincipal();
            if (principal == null && this.tryRelogin()) {
                principal = httpRequest.getUserPrincipal();
            }
            if (principal == null) {
                HttpSession httpSession;
                if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                    throw SecurityServiceException.newSessionExpiredException("Session expired");
                }
                throw SecurityServiceException.newNotLoggedInException("User not logged in");
            }
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!httpRequest.isUserInRole(role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException) && !"javax.ejb.EJBAccessException".equals(t.getClass().getName())) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        this.endLogout();
        if (httpRequest.getSession(false) != null) {
            httpRequest.getSession().invalidate();
        }
        ServletAuthentication.logout((HttpServletRequest)httpRequest);
    }
}

