/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.tide;

import java.util.Set;
import java.util.regex.Pattern;
import org.granite.messaging.service.tide.TideComponentMatcher;

public class TideComponentTypeMatcher
implements TideComponentMatcher {
    private final boolean disabled;
    private final Pattern pattern;

    public TideComponentTypeMatcher(String type, boolean disabled) {
        this.pattern = Pattern.compile(type);
        this.disabled = disabled;
    }

    @Override
    public boolean matches(String name, Set<Class<?>> classes, Object instance, boolean disabled) {
        for (Class<?> clazz : classes) {
            if (disabled != this.disabled || !this.pattern.matcher(clazz.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Type matcher: " + this.pattern.pattern() + (this.disabled ? " (disabled)" : "");
    }
}

