/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.granite.config.GraniteConfigListener;
import org.granite.logging.Logger;
import org.granite.messaging.jmf.JMFDumper;
import org.granite.messaging.jmf.SharedContext;
import org.granite.util.ContentType;

public class JMFDumpFilter
implements Filter {
    private static final Logger log = Logger.getLogger(JMFDumpFilter.class);
    private SharedContext jmfSharedContext = null;

    public void init(FilterConfig config) throws ServletException {
        this.jmfSharedContext = GraniteConfigListener.getDumpSharedContext(config.getServletContext());
        if (this.jmfSharedContext == null) {
            throw GraniteConfigListener.newSharedContextNotInitializedException();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ContentType.JMF_AMF.mimeType().equals(request.getContentType())) {
            log.info("Ignoring request with content-type: " + request.getContentType(), new Object[0]);
            chain.doFilter(request, response);
        } else {
            DumpRequestWrapper requestWrapper = new DumpRequestWrapper((HttpServletRequest)request);
            DumpResponseWrapper responseWrapper = new DumpResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
    }

    public void destroy() {
        this.jmfSharedContext = null;
    }

    private void dumpBytes(String label, byte[] bytes) throws IOException {
        String encoding = "UTF-8";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
        JMFDumper dumper = new JMFDumper(new ByteArrayInputStream(bytes), this.jmfSharedContext, ps);
        dumper.dump();
        dumper.close();
        log.info("[JMF %s (%d bytes)]\n%s", label.toUpperCase(), bytes.length, new String(baos.toByteArray(), "UTF-8"));
    }

    class DumpResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream baos;

        public DumpResponseWrapper(HttpServletResponse response) {
            super(response);
            this.baos = new ByteArrayOutputStream(256);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            ServletOutputStream os = this.getResponse().getOutputStream();
            return new ServletOutputStream((OutputStream)os){
                final /* synthetic */ OutputStream val$os;
                {
                    this.val$os = outputStream;
                }

                public void write(int b) throws IOException {
                    DumpResponseWrapper.this.baos.write(b);
                    this.val$os.write(b);
                }

                public void close() throws IOException {
                    this.val$os.close();
                    JMFDumpFilter.this.dumpBytes("response", DumpResponseWrapper.this.baos.toByteArray());
                }
            };
        }
    }

    class DumpRequestWrapper
    extends HttpServletRequestWrapper {
        private final ByteArrayOutputStream baos;

        public DumpRequestWrapper(HttpServletRequest request) {
            super(request);
            this.baos = new ByteArrayOutputStream();
        }

        public ServletInputStream getInputStream() throws IOException {
            ServletInputStream is = this.getRequest().getInputStream();
            return new ServletInputStream((InputStream)is){
                final /* synthetic */ InputStream val$is;
                {
                    this.val$is = inputStream;
                }

                public int read() throws IOException {
                    int b = this.val$is.read();
                    if (b != -1) {
                        DumpRequestWrapper.this.baos.write(b);
                    }
                    return b;
                }

                public int available() throws IOException {
                    return this.val$is.available();
                }

                public void close() throws IOException {
                    this.val$is.close();
                    JMFDumpFilter.this.dumpBytes("request", DumpRequestWrapper.this.baos.toByteArray());
                }
            };
        }
    }
}

