/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.granite.scan.AbstractScannedItem;
import org.granite.scan.Scanner;

public class ZipScannedItem
extends AbstractScannedItem {
    private final ZipFile file;
    private final ZipEntry entry;

    public ZipScannedItem(Scanner scanner, ZipScannedItem marker, ZipFile file, ZipEntry entry) {
        super(scanner, marker);
        this.file = file;
        this.entry = entry;
    }

    public ZipFile getFile() {
        return this.file;
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public String getName() {
        String path = this.entry.getName();
        int lastSlash = path.lastIndexOf(47);
        return lastSlash >= 0 ? path.substring(lastSlash + 1) : path;
    }

    @Override
    public String getRelativePath() {
        return this.entry.getName();
    }

    @Override
    public String getAbsolutePath() {
        return new File(this.file.getName()).getAbsolutePath() + '!' + this.entry.getName();
    }

    @Override
    public long getSize() {
        return this.entry.getSize();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream(this.entry);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZipScannedItem)) {
            return false;
        }
        return this.file.equals(((ZipScannedItem)obj).file) && this.entry.equals(((ZipScannedItem)obj).entry);
    }

    public int hashCode() {
        return this.file.hashCode() + 31 * this.entry.hashCode();
    }
}

