/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.granite.tide.data.model.SortInfo;

public class PageInfo
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private int firstResult;
    private int maxResults;
    private SortInfo sortInfo;

    public PageInfo() {
    }

    public PageInfo(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.sortInfo = null;
    }

    public PageInfo(int firstResult, int maxResults, String[] order, boolean[] desc) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.sortInfo = order != null && desc != null && order.length > 0 && desc.length > 0 ? new SortInfo(order, desc) : null;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.firstResult);
        out.writeObject(this.maxResults);
        out.writeObject(this.sortInfo != null ? this.sortInfo.getOrder() : null);
        out.writeObject(this.sortInfo != null ? this.sortInfo.getDesc() : null);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.firstResult = (Integer)in.readObject();
        this.maxResults = (Integer)in.readObject();
        Object[] oorder = (Object[])in.readObject();
        Object[] odesc = (Object[])in.readObject();
        if (oorder == null || odesc == null) {
            this.sortInfo = null;
            return;
        }
        String[] order = new String[oorder.length];
        boolean[] desc = new boolean[oorder.length];
        int i = 0;
        for (Object o : oorder) {
            order[i++] = (String)o;
        }
        i = 0;
        for (Object d : odesc) {
            desc[i++] = (Boolean)d;
        }
        this.sortInfo = new SortInfo(order, desc);
    }
}

