/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import org.granite.config.flex.Destination;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.gravity.adapters.DefaultSecurityPolicy;
import org.granite.gravity.adapters.SecurityPolicy;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;

public abstract class ServiceAdapter {
    private static final Logger log = Logger.getLogger(ServiceAdapter.class);
    private String id;
    private Gravity gravity;
    private Destination destination;
    private Object adapterState;
    private SecurityPolicy securityPolicy = new DefaultSecurityPolicy();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Object getAdapterState() {
        return this.adapterState;
    }

    public void setAdapterState(Object adapterState) {
        this.adapterState = adapterState;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        String securityPolicy = adapterProperties.get("security-policy");
        if (securityPolicy != null) {
            try {
                this.securityPolicy = TypeUtil.newInstance(securityPolicy, SecurityPolicy.class);
            }
            catch (Exception e) {
                log.error(e, "Could not create instance of %s (using default security policy)", securityPolicy);
            }
        }
    }

    public void start() throws ServiceException {
    }

    public void stop() throws ServiceException {
    }

    public abstract Object manage(Channel var1, CommandMessage var2);

    public abstract Object invoke(Channel var1, AsyncMessage var2);
}

