/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.tomcat.CometIO;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.logging.Logger;

public abstract class AbstractCometProcessor
extends AbstractGravityServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractCometProcessor.class);
    private boolean longPollingTimeoutSupported = true;

    public abstract CometIO createCometIO();

    public abstract boolean handleRequest(CometEvent var1, InputStream var2) throws IOException, ServletException;

    public abstract boolean handleEnd(CometEvent var1) throws IOException, ServletException;

    public abstract boolean handleError(CometEvent var1) throws IOException, ServletException;

    public void event(CometEvent event) throws IOException, ServletException {
        if (!EventUtil.isValid(event)) {
            log.error("Tomcat sent an invalid CometEvent: %s.%s", event.getEventType(), event.getEventSubType());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("%s.%s: %s/%s", event.getEventType(), event.getEventSubType(), event.getHttpServletRequest(), event.getHttpServletResponse());
        }
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.begin(event);
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.read(event);
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.end(event);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.error(event);
        } else {
            throw new ServletException("Unknown CometEvent type: " + event.getEventType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void begin(CometEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            if (this.longPollingTimeoutSupported) {
                try {
                    event.setTimeout((int)this.getLongPollingTimeout());
                }
                catch (Exception e) {
                    this.longPollingTimeoutSupported = false;
                }
            }
            HttpServletRequest request = event.getHttpServletRequest();
            CometIO io = this.createCometIO();
            io.readFully((InputStream)request.getInputStream());
            request.getParameter("");
            close = this.handleRequest(event, io.getInputStream());
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    protected void read(CometEvent event) {
        throw new RuntimeException("Unsupported operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void end(CometEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            close = this.handleEnd(event);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void error(CometEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            close = this.handleError(event);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("Not in a valid Comet configuration (use an APR or NIO connector)");
    }
}

