/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.granite.messaging.amf.AMF0Body;
import org.granite.messaging.amf.AMF0Header;

public class AMF0Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 3;
    protected int version = 3;
    protected final List<AMF0Header> headers = new ArrayList<AMF0Header>();
    protected final List<AMF0Body> bodies = new ArrayList<AMF0Body>();

    public void addHeader(String key, boolean required, Object value) {
        this.addHeader(new AMF0Header(key, required, value));
    }

    public void addHeader(AMF0Header header) {
        this.headers.add(header);
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public AMF0Header getHeader(int index) {
        return this.headers.get(index);
    }

    public List<AMF0Header> getHeaders() {
        return this.headers;
    }

    public AMF0Body addBody(String target, String response, Object value, byte type) {
        return this.addBody(new AMF0Body(target, response, value, type));
    }

    public AMF0Body addBody(AMF0Body body) {
        this.bodies.add(body);
        return body;
    }

    public int getBodyCount() {
        return this.bodies.size();
    }

    public AMF0Body getBody(int index) {
        return this.bodies.get(index);
    }

    public Iterator<AMF0Body> getBodies() {
        return this.bodies.iterator();
    }

    public boolean isFirstMessage() {
        if (this.bodies.size() == 1) {
            return this.bodies.get(0).isFirstBody();
        }
        for (AMF0Body body : this.bodies) {
            if (!body.isFirstBody()) continue;
            return true;
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBodiesString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.bodies.size(); ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            AMF0Body amfBody = this.bodies.get(i);
            sb.append(amfBody);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        int i;
        String innerIndent = indent + "    ";
        StringBuilder sb = new StringBuilder(2048);
        sb.append('\n').append(indent).append(AMF0Message.class.getName()).append(" {");
        sb.append('\n').append(indent).append("  version = ").append(this.version);
        sb.append('\n').append(indent).append("  headers = [");
        for (i = 0; i < this.headers.size(); ++i) {
            AMF0Header amfHeader = this.headers.get(i);
            sb.append(amfHeader.toString(innerIndent));
        }
        if (this.headers.size() > 0) {
            sb.append('\n').append(indent).append("  ");
        }
        sb.append(']');
        sb.append('\n').append(indent).append("  bodies = [");
        for (i = 0; i < this.bodies.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            AMF0Body amfBody = this.bodies.get(i);
            sb.append(amfBody.toString(innerIndent));
        }
        if (this.bodies.size() > 0) {
            sb.append('\n').append(indent).append("  ");
        }
        sb.append(']');
        sb.append('\n').append(indent).append("}");
        return sb.toString();
    }
}

