/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.ArrayListCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class ArrayListCodecImpl
extends AbstractStandardCodec<ArrayList<?>>
implements ArrayListCodec {
    protected static final int INDEX_OR_LENGTH_BYTE_COUNT_OFFSET = 5;

    @Override
    public int getObjectType() {
        return 10;
    }

    @Override
    public Class<?> getObjectClass() {
        return ArrayList.class;
    }

    @Override
    public void encode(OutputContext ctx, ArrayList<?> v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfObject(v);
        if (indexOfStoredObject >= 0) {
            int count = IntegerUtil.significantIntegerBytesCount0(indexOfStoredObject);
            os.write(0x80 | count << 5 | 0xA);
            IntegerUtil.encodeInteger(ctx, indexOfStoredObject, count);
        } else {
            ctx.addToObjects(v);
            Object[] snapshot = v.toArray();
            int count = IntegerUtil.significantIntegerBytesCount0(snapshot.length);
            os.write(count << 5 | 0xA);
            IntegerUtil.encodeInteger(ctx, snapshot.length, count);
            for (Object element : snapshot) {
                ctx.writeObject(element);
            }
        }
    }

    @Override
    public ArrayList<?> decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 5 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            return (ArrayList)ctx.getObject(indexOrLength);
        }
        ArrayList<Object> v = new ArrayList<Object>(indexOrLength);
        ctx.addToObjects(v);
        for (int index = 0; index < indexOrLength; ++index) {
            v.add(index, ctx.readObject());
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 10) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 5 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            String v = (String)ctx.getObject(indexOrLength);
            ctx.indentPrintLn("<" + v + "@" + indexOrLength + ">");
            return;
        }
        String v = ArrayList.class.getName() + "[" + indexOrLength + "]";
        int indexOfStoredObject = ctx.addToObjects(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + " {");
        ctx.incrIndent(1);
        for (int index = 0; index < indexOrLength; ++index) {
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            StandardCodec codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }
}

