/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.CharacterCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class CharacterCodecImpl
extends AbstractStandardCodec<Character>
implements CharacterCodec {
    @Override
    public int getObjectType() {
        return 59;
    }

    @Override
    public Class<?> getObjectClass() {
        return Character.class;
    }

    @Override
    public int getPrimitiveType() {
        return 58;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Character.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Character v) throws IOException {
        this.writeCharData(ctx, 59, v.charValue());
    }

    @Override
    public Character decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return Character.valueOf(this.readCharData(ctx, parameterizedJmfType));
    }

    @Override
    public void encodePrimitive(OutputContext ctx, int v) throws IOException {
        this.writeCharData(ctx, 58, v);
    }

    @Override
    public char decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        return this.readCharData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 58: {
                ctx.indentPrintLn("char: '" + this.escape(this.readCharData(ctx, parameterizedJmfType)) + "'");
                break;
            }
            case 59: {
                ctx.indentPrintLn(Character.class.getName() + ": '" + this.escape(this.readCharData(ctx, parameterizedJmfType)) + "'");
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    protected void writeCharData(OutputContext ctx, int jmfType, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v <= 255) {
            os.write(jmfType);
            os.write(v);
        } else {
            os.write(0x80 | jmfType);
            os.write(v >>> 8);
            os.write(v);
        }
    }

    protected char readCharData(InputContext ctx, int parameterizedJmfType) throws IOException {
        char v = (char)ctx.safeRead();
        if ((parameterizedJmfType & 0x80) != 0) {
            v = (char)(v << 8 | ctx.safeRead());
        }
        return v;
    }
}

