/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.DoubleCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.DoubleUtil;
import org.granite.messaging.jmf.codec.std.impl.util.LongUtil;

public class DoubleCodecImpl
extends AbstractStandardCodec<Double>
implements DoubleCodec {
    protected static final int POW_10_OFFSET = 4;

    @Override
    public int getObjectType() {
        return 1;
    }

    @Override
    public Class<?> getObjectClass() {
        return Double.class;
    }

    @Override
    public int getPrimitiveType() {
        return 0;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Double.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Double v) throws IOException {
        DoubleCodecImpl.writeDoubleData(ctx, 1, v);
    }

    @Override
    public Double decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, double v) throws IOException {
        DoubleCodecImpl.writeDoubleData(ctx, 0, v);
    }

    @Override
    public double decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        return DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 0: {
                ctx.indentPrintLn("double: " + DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType));
                break;
            }
            case 1: {
                ctx.indentPrintLn(Double.class.getName() + ": " + Double.valueOf(DoubleCodecImpl.readDoubleData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    public static void writeDoubleData(OutputContext ctx, int jmfType, double v) throws IOException {
        DoubleUtil.DoubleAsLong asLong;
        OutputStream os = ctx.getOutputStream();
        long bits = Double.doubleToLongBits(v);
        if ((bits & 0x7FF0000000000000L) != 0x7FF0000000000000L && bits != Long.MIN_VALUE && (asLong = DoubleUtil.doubleAsLong04(v)) != null && asLong.longValue >= -283691315109952L && asLong.longValue <= 283691315109951L) {
            os.write(0x80 | asLong.pow10 << 4 | jmfType);
            LongUtil.encodeVariableLong(ctx, asLong.longValue);
            return;
        }
        os.write(jmfType);
        LongUtil.encodeLong(ctx, bits);
    }

    public static double readDoubleData(InputContext ctx, int parameterizedJmfType) throws IOException {
        if ((parameterizedJmfType & 0x80) != 0) {
            long asLong = LongUtil.decodeVariableLong(ctx);
            int pow10 = parameterizedJmfType >>> 4 & 7;
            switch (pow10) {
                case 0: {
                    return asLong;
                }
                case 2: {
                    return (double)asLong / 100.0;
                }
                case 4: {
                    return (double)asLong / 10000.0;
                }
            }
            throw new JMFEncodingException("Unsupported power of 10: " + pow10);
        }
        return Double.longBitsToDouble(LongUtil.decodeLong(ctx));
    }
}

