/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.persistence;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.persistence.AbstractExternalizablePersistentCollection;

public class ExternalizablePersistentList
extends AbstractExternalizablePersistentCollection {
    private static final long serialVersionUID = 1L;

    public ExternalizablePersistentList() {
    }

    public ExternalizablePersistentList(List<?> content, boolean initialized, boolean dirty) {
        super(null, initialized, dirty);
        this.setContentFromList(content);
    }

    public ExternalizablePersistentList(Object[] content, boolean initialized, boolean dirty) {
        super(content, initialized, dirty);
    }

    public List<?> getContentAsList(Type target) {
        ArrayList<Object> list = null;
        if (this.content != null) {
            list = new ArrayList<Object>(this.content.length);
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            Type[] typeArguments = null;
            if (target instanceof ParameterizedType) {
                typeArguments = ((ParameterizedType)target).getActualTypeArguments();
            }
            for (Object o : this.content) {
                if (typeArguments != null) {
                    list.add(converters.convert(o, typeArguments[0]));
                    continue;
                }
                list.add(o);
            }
        }
        return list;
    }

    public void setContentFromList(List<?> list) {
        this.content = list != null ? list.toArray() : null;
    }
}

