/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.DefaultServiceExceptionHandler;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;

public class ExtendedServiceExceptionHandler
extends DefaultServiceExceptionHandler {
    private static final long serialVersionUID = -1L;
    private static final Logger log = Logger.getLogger(ExtendedServiceExceptionHandler.class);
    public static final Class<?> JAVAX_EJB_EXCEPTION;

    public ExtendedServiceExceptionHandler() {
        this(true);
    }

    public ExtendedServiceExceptionHandler(boolean logException) {
        super(logException);
    }

    @Override
    protected ServiceException getServiceException(Message request, Destination destination, String method, Throwable t) {
        if (t == null) {
            throw new NullPointerException("Parameter t cannot be null");
        }
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        if (t instanceof ServiceException) {
            ((ServiceException)t).getExtendedData().putAll(extendedData);
            return (ServiceException)t;
        }
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        Throwable cause = t;
        while (cause != null) {
            causes.add(cause);
            cause = ExtendedServiceExceptionHandler.getCause(cause);
        }
        String detail = "\n- destination: " + (destination != null ? destination.getId() : "") + "\n" + "- method: " + method + "\n" + "- exception: " + t.toString() + "\n";
        for (int i = causes.size() - 1; i >= 0; --i) {
            Throwable cause2 = (Throwable)causes.get(i);
            for (ExceptionConverter ec : GraniteContext.getCurrentInstance().getGraniteConfig().getExceptionConverters()) {
                if (!ec.accepts(cause2, t)) continue;
                return ec.convert(cause2, detail, extendedData);
            }
        }
        if (this.getLogException()) {
            log.error(t, "Could not process remoting message: %s", request);
        }
        ServiceException se = new ServiceException(t.getClass().getSimpleName() + ".Call.Failed", t.getMessage(), detail, t);
        se.getExtendedData().putAll(extendedData);
        return se;
    }

    public static Throwable getCause(Throwable t) {
        Throwable cause = null;
        try {
            if (JAVAX_EJB_EXCEPTION != null && JAVAX_EJB_EXCEPTION.isInstance(t)) {
                Method m = JAVAX_EJB_EXCEPTION.getMethod("getCausedByException", new Class[0]);
                cause = (Throwable)m.invoke((Object)t, new Object[0]);
            } else {
                cause = t instanceof ServletException ? ((ServletException)t).getRootCause() : t.getCause();
            }
        }
        catch (Exception x) {
            return null;
        }
        return cause == t ? null : cause;
    }

    static {
        Class<?> exception = null;
        try {
            exception = Thread.currentThread().getContextClassLoader().loadClass("javax.ejb.EJBException");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        JAVAX_EJB_EXCEPTION = exception;
    }
}

