/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

public enum ContentType {
    AMF("application/x-amf"),
    JMF_AMF("application/x-jmf+amf");

    public static final String KEY = "Content-Type";
    private final String mimeType;

    private ContentType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public static ContentType forMimeType(String mimeType) {
        for (ContentType type : ContentType.values()) {
            if (!type.mimeType.equals(mimeType)) continue;
            return type;
        }
        return null;
    }
}

