/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.servlet3;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.granite.clustering.CreateSessionFilter;
import org.granite.config.ConfigProvider;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.config.servlet3.ServerFilter;
import org.granite.config.servlet3.Servlet3Configurator;
import org.granite.gravity.GravityManager;
import org.granite.gravity.config.AbstractActiveMQTopicDestination;
import org.granite.gravity.config.AbstractJmsTopicDestination;
import org.granite.gravity.config.AbstractMessagingDestination;
import org.granite.gravity.config.servlet3.ActiveMQTopicDestination;
import org.granite.gravity.config.servlet3.JmsTopicDestination;
import org.granite.gravity.config.servlet3.MessagingDestination;
import org.granite.gravity.security.GravityDestinationSecurizer;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.externalizer.BigDecimalExternalizer;
import org.granite.messaging.amf.io.util.externalizer.BigIntegerExternalizer;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.externalizer.LongExternalizer;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.messaging.service.security.RemotingDestinationSecurizer;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;
import org.granite.messaging.webapp.AMFMessageFilter;
import org.granite.messaging.webapp.AMFMessageServlet;
import org.granite.util.TypeUtil;
import org.granite.util.XMap;

@HandlesTypes(value={ServerFilter.class})
public class GraniteServlet3Initializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> scannedClasses, ServletContext servletContext) throws ServletException {
        HashSet classes = new HashSet();
        if (scannedClasses != null) {
            classes.addAll(scannedClasses);
            classes.remove(ServerFilter.class);
        }
        if (classes.size() > 1) {
            throw new ServletException("Application must have only one ServerFilter configuration class");
        }
        if (!classes.isEmpty()) {
            Class clazz = (Class)classes.iterator().next();
            ServerFilter serverFilter = clazz.getAnnotation(ServerFilter.class);
            servletContext.setAttribute("org.granite.config.serverFilter", (Object)new Servlet3ServiceConfigurator(clazz));
            servletContext.addListener((EventListener)((Object)new GraniteConfigListener()));
            if (serverFilter.forceCreateSession() && servletContext.getFilterRegistration("CreateSessionFilter") == null) {
                FilterRegistration.Dynamic createSessionFilter = servletContext.addFilter("CreateSessionFilter", CreateSessionFilter.class);
                createSessionFilter.setAsyncSupported(true);
                createSessionFilter.addMappingForUrlPatterns(null, true, new String[]{serverFilter.graniteUrlMapping(), serverFilter.gravityUrlMapping()});
            }
            if (servletContext.getFilterRegistration("AMFMessageFilter") == null) {
                FilterRegistration.Dynamic graniteFilter = servletContext.addFilter("AMFMessageFilter", AMFMessageFilter.class);
                graniteFilter.addMappingForUrlPatterns(null, true, new String[]{serverFilter.graniteUrlMapping()});
            }
            if (servletContext.getServletRegistration("AMFMessageServlet") == null) {
                ServletRegistration.Dynamic graniteServlet = servletContext.addServlet("AMFMessageServlet", AMFMessageServlet.class);
                graniteServlet.setLoadOnStartup(1);
                graniteServlet.addMapping(new String[]{serverFilter.graniteUrlMapping()});
            }
            try {
                if (servletContext.getServletRegistration("GravityServlet") == null) {
                    Class<Servlet> gravityAsyncServletClass = TypeUtil.forName("org.granite.gravity.servlet3.GravityAsyncServlet", Servlet.class);
                    ServletRegistration.Dynamic gravityServlet = servletContext.addServlet("GravityServlet", gravityAsyncServletClass);
                    gravityServlet.setLoadOnStartup(1);
                    gravityServlet.setAsyncSupported(true);
                    gravityServlet.addMapping(new String[]{serverFilter.gravityUrlMapping()});
                }
            }
            catch (ClassNotFoundException e) {
                servletContext.log("Could not setup GravityAsyncServlet", (Throwable)e);
            }
            if (servletContext.getServletRegistration("WebSocketServlet") == null) {
                try {
                    TypeUtil.forName("javax.websocket.server.ServerEndpointConfig");
                    try {
                        servletContext.addListener(TypeUtil.forName("org.granite.gravity.websocket.GravityWebSocketDeployer", ServletContextListener.class));
                    }
                    catch (ClassNotFoundException f) {
                        servletContext.log("Could not setup WebSocket deployer", (Throwable)f);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void initSecurizer(AbstractMessagingDestination messagingDestination, Class<? extends GravityDestinationSecurizer> securizerClass, ConfigProvider configProvider) {
        if (securizerClass != GravityDestinationSecurizer.class) {
            if (configProvider != null) {
                messagingDestination.setSecurizer(configProvider.findInstance(securizerClass));
            }
            if (messagingDestination.getSecurizer() == null) {
                messagingDestination.setSecurizerClassName(securizerClass.getName());
            }
        }
    }

    public static class Servlet3ServiceConfigurator
    implements GraniteConfigListener.ServiceConfigurator,
    GravityManager.GravityServiceConfigurator {
        private static final Logger log = Logger.getLogger(Servlet3ServiceConfigurator.class);
        private final Class<?> serverFilterClass;
        private static Map<String, String> securityServicesMap = new LinkedHashMap<String, String>();

        public Servlet3ServiceConfigurator(Class<?> serverFilterClass) {
            this.serverFilterClass = serverFilterClass;
        }

        @Override
        public void initialize(ServletContext servletContext) {
            servletContext.setAttribute(ServletGraniteConfig.GRANITE_CONFIG_DEFAULT_KEY, (Object)"org/granite/config/servlet3/granite-config-servlet3.xml");
        }

        @Override
        public void configureServices(ServletContext servletContext) throws ServletException {
            Service service;
            Factory factory;
            GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(servletContext);
            ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(servletContext, true);
            ServerFilter serverFilter = this.serverFilterClass.getAnnotation(ServerFilter.class);
            ConfigProvider configProvider = null;
            boolean useTide = serverFilter.tide();
            String type = serverFilter.type();
            Class<? extends ServiceFactory> factoryClass = null;
            HashSet tideInterfaces = new HashSet(Arrays.asList(serverFilter.tideInterfaces()));
            HashSet<Class<? extends Annotation>> tideAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(serverFilter.tideAnnotations()));
            if (!serverFilter.configProviderClass().equals(ConfigProvider.class)) {
                try {
                    configProvider = TypeUtil.newInstance(serverFilter.configProviderClass(), new Class[]{ServletContext.class}, new Object[]{servletContext});
                    servletContext.setAttribute("org.granite.config.configProvider", (Object)configProvider);
                    if (configProvider.useTide() != null) {
                        useTide = configProvider.useTide();
                    }
                    if (configProvider.getType() != null) {
                        type = configProvider.getType();
                    }
                    factoryClass = configProvider.getFactoryClass();
                    if (configProvider.getTideInterfaces() != null) {
                        tideInterfaces.addAll(Arrays.asList(configProvider.getTideInterfaces()));
                    }
                    if (configProvider.getTideAnnotations() != null) {
                        tideAnnotations.addAll(Arrays.asList(configProvider.getTideAnnotations()));
                    }
                }
                catch (Exception e) {
                    log.error(e, "Could not set config provider of type %s", serverFilter.configProviderClass().getName());
                }
            }
            if (!serverFilter.factoryClass().equals(ServiceFactory.class)) {
                factoryClass = serverFilter.factoryClass();
            } else if (!serverFilter.factoryClassName().equals("")) {
                try {
                    factoryClass = TypeUtil.forName(serverFilter.factoryClassName(), ServiceFactory.class);
                }
                catch (ClassNotFoundException e) {
                    throw new ServletException("Could not find service factory class " + serverFilter.factoryClassName(), (Throwable)e);
                }
            }
            if (factoryClass == null) {
                factoryClass = useTide ? org.granite.tide.simple.SimpleServiceFactory.class : SimpleServiceFactory.class;
            }
            for (Class clazz : tideInterfaces) {
                try {
                    graniteConfig.getTideComponentMatchers().add(new TideComponentInstanceOfMatcher(clazz.getName(), false));
                    log.debug("Enabled components implementing %s for Tide remoting", clazz);
                }
                catch (Exception e) {
                    log.error(e, "Could not add tide-component interface %s", clazz);
                }
            }
            for (Class clazz : tideAnnotations) {
                try {
                    graniteConfig.getTideComponentMatchers().add(new TideComponentAnnotatedWithMatcher(clazz.getName(), false));
                    log.debug("Enabled components annotated with %s for Tide remoting", clazz);
                }
                catch (Exception e) {
                    log.error(e, "Could not add tide-component annotation %s", clazz);
                }
            }
            for (String tn : serverFilter.tideNames()) {
                try {
                    graniteConfig.getTideComponentMatchers().add(new TideComponentNameMatcher(tn, false));
                    log.debug("Enabled components with name %s for Tide remoting", tn);
                }
                catch (Exception e) {
                    log.error(e, "Could not add tide-component name %s", tn);
                }
            }
            for (String tt : serverFilter.tideTypes()) {
                try {
                    graniteConfig.getTideComponentMatchers().add(new TideComponentTypeMatcher(tt, false));
                    log.debug("Enabled components with type %s for Tide remoting", tt);
                }
                catch (Exception e) {
                    log.error(e, "Could not add tide-component type %s", tt);
                }
            }
            for (Class<? extends ExceptionConverter> ec : serverFilter.exceptionConverters()) {
                graniteConfig.registerExceptionConverter(ec, true);
                log.debug("Registered exception converter %s", ec);
            }
            if (configProvider != null) {
                for (ExceptionConverter exceptionConverter : configProvider.findInstances(ExceptionConverter.class)) {
                    graniteConfig.registerExceptionConverter(exceptionConverter, true);
                    log.debug("Registered exception converter %s", exceptionConverter.getClass());
                }
            }
            if (configProvider != null) {
                for (Externalizer externalizer : configProvider.findInstances(Externalizer.class)) {
                    graniteConfig.registerExternalizer(externalizer);
                    log.debug("Registered externalizer %s", externalizer.getClass());
                }
            }
            if (serverFilter.useBigDecimal()) {
                graniteConfig.setExternalizersByType(BigDecimal.class.getName(), BigDecimalExternalizer.class.getName());
            }
            if (serverFilter.useBigInteger()) {
                graniteConfig.setExternalizersByType(BigInteger.class.getName(), BigIntegerExternalizer.class.getName());
            }
            if (serverFilter.useLong()) {
                graniteConfig.setExternalizersByType(Long.class.getName(), LongExternalizer.class.getName());
            }
            if (!serverFilter.securityServiceClass().equals(SecurityService.class)) {
                try {
                    graniteConfig.setSecurityService(TypeUtil.newInstance(serverFilter.securityServiceClass(), SecurityService.class));
                }
                catch (Exception e) {
                    throw new ServletException("Could not setup security service", (Throwable)e);
                }
            } else if (graniteConfig.getSecurityService() == null && configProvider != null) {
                SecurityService securityService = configProvider.findInstance(SecurityService.class);
                graniteConfig.setSecurityService(securityService);
            }
            if (graniteConfig.getSecurityService() == null) {
                String securityServiceClassName = null;
                for (Map.Entry<String, String> entry : securityServicesMap.entrySet()) {
                    try {
                        TypeUtil.forName(entry.getKey());
                        securityServiceClassName = entry.getValue();
                        break;
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                try {
                    if (securityServiceClassName != null) {
                        graniteConfig.setSecurityService((SecurityService)TypeUtil.newInstance(securityServiceClassName));
                    }
                }
                catch (Exception exception) {
                    log.error(exception, "Could not setup security service " + securityServiceClassName, new Object[0]);
                }
            }
            if (!serverFilter.amf3MessageInterceptor().equals(AMF3MessageInterceptor.class)) {
                try {
                    graniteConfig.setAmf3MessageInterceptor(TypeUtil.newInstance(serverFilter.amf3MessageInterceptor(), AMF3MessageInterceptor.class));
                }
                catch (Exception e) {
                    throw new ServletException("Could not setup amf3 message interceptor", (Throwable)e);
                }
            } else if (graniteConfig.getAmf3MessageInterceptor() == null && configProvider != null) {
                AMF3MessageInterceptor amf3MessageInterceptor = configProvider.findInstance(AMF3MessageInterceptor.class);
                graniteConfig.setAmf3MessageInterceptor(amf3MessageInterceptor);
            }
            Channel channel = servicesConfig.findChannelById("graniteamf");
            if (channel == null) {
                channel = new Channel("graniteamf", "mx.messaging.channels.AMFChannel", new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint"), new XMap());
                servicesConfig.addChannel(channel);
            }
            XMap xMap = new XMap();
            String lookup = null;
            if (useTide) {
                lookup = "java:global{context.root}/{capitalized.component.name}Bean";
                if (Servlet3ServiceConfigurator.isJBoss6()) {
                    lookup = "{capitalized.component.name}Bean/local";
                }
                if (!"".equals(serverFilter.ejbLookup())) {
                    lookup = serverFilter.ejbLookup();
                }
            } else {
                lookup = "java:global{context.root}/{capitalized.destination.id}Bean";
                if (Servlet3ServiceConfigurator.isJBoss6()) {
                    lookup = "{capitalized.destination.id}Bean/local";
                }
                if (!"".equals(serverFilter.ejbLookup())) {
                    lookup = serverFilter.ejbLookup();
                }
            }
            if (lookup.indexOf("{context.root}") >= 0) {
                try {
                    Method m = servletContext.getClass().getMethod("getContextPath", new Class[0]);
                    m.setAccessible(true);
                    String contextPath = (String)m.invoke((Object)servletContext, new Object[0]);
                    lookup = lookup.replace("{context.root}", contextPath);
                }
                catch (Exception e) {
                    log.error(e, "Could not get context path, please define lookup manually in @ServerFilter", new Object[0]);
                }
            }
            xMap.put("lookup", lookup);
            xMap.put("enable-exception-logging", String.valueOf(serverFilter.enableExceptionLogging()));
            if (useTide) {
                factory = servicesConfig.findFactoryById("tide-" + type + "-factory");
                if (factory == null) {
                    factory = new Factory("tide-" + type + "-factory", factoryClass.getName(), xMap);
                    servicesConfig.addFactory(factory);
                }
                if ((service = servicesConfig.findServiceById("granite-service")) == null) {
                    service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
                    ArrayList<String> channelIds = new ArrayList<String>();
                    channelIds.add("graniteamf");
                    List<String> tideRoles = serverFilter.tideRoles().length == 0 ? null : Arrays.asList(serverFilter.tideRoles());
                    Destination destination = new Destination(type, channelIds, new XMap(), tideRoles, null, null);
                    destination.getProperties().put("factory", "tide-" + type + "-factory");
                    if (!"".equals(serverFilter.entityManagerFactoryJndiName())) {
                        destination.getProperties().put("entity-manager-factory-jndi-name", serverFilter.entityManagerFactoryJndiName());
                    } else if (!"".equals(serverFilter.entityManagerJndiName())) {
                        destination.getProperties().put("entity-manager-jndi-name", serverFilter.entityManagerJndiName());
                    }
                    if (!"".equals(serverFilter.validatorClassName())) {
                        destination.getProperties().put("validator-class-name", serverFilter.validatorClassName());
                    }
                    service.getDestinations().put(type, destination);
                    if (destination.getSecurizer() == null && configProvider != null) {
                        RemotingDestinationSecurizer securizer = configProvider.findInstance(RemotingDestinationSecurizer.class);
                        destination.setSecurizer(securizer);
                    }
                    servicesConfig.addService(service);
                }
                if (factoryClass.getName().equals("org.granite.tide.ejb.EjbServiceFactory") || factoryClass.getName().equals("org.granite.tide.simple.SimpleServiceFactory")) {
                    servicesConfig.scan(null);
                }
                log.info("Registered Tide " + factoryClass + " service factory and " + type + " destination", new Object[0]);
            } else {
                factory = new Factory(type + "-factory", factoryClass.getName(), xMap);
                servicesConfig.addFactory(factory);
                service = new Service("granite-service", "flex.messaging.services.RemotingService", "flex.messaging.messages.RemotingMessage", null, null, new HashMap<String, Destination>());
                servicesConfig.addService(service);
                servicesConfig.scan(null);
                log.info("Registered " + factoryClass + " service factory", new Object[0]);
            }
        }

        private static boolean isJBoss6() {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/org/jboss/version.properties");
                if (is != null) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        @Override
        public void configureGravityServices(ServletContext servletContext) throws ServletException {
            ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(servletContext);
            ConfigProvider configProvider = (ConfigProvider)servletContext.getAttribute("org.granite.config.configProvider");
            ServiceLoader<Servlet3Configurator> configurators = ServiceLoader.load(Servlet3Configurator.class);
            for (Field field : this.serverFilterClass.getDeclaredFields()) {
                AbstractMessagingDestination messagingDestination;
                Annotation md;
                if (field.isAnnotationPresent(MessagingDestination.class)) {
                    md = field.getAnnotation(MessagingDestination.class);
                    messagingDestination = new AbstractMessagingDestination();
                    messagingDestination.setId(field.getName());
                    messagingDestination.setNoLocal(md.noLocal());
                    messagingDestination.setSessionSelector(md.sessionSelector());
                    if (md.securityRoles().length > 0) {
                        messagingDestination.setRoles(Arrays.asList(md.securityRoles()));
                    }
                    GraniteServlet3Initializer.initSecurizer(messagingDestination, md.securizer(), configProvider);
                    messagingDestination.initServices(servicesConfig);
                    continue;
                }
                if (field.isAnnotationPresent(JmsTopicDestination.class)) {
                    md = field.getAnnotation(JmsTopicDestination.class);
                    messagingDestination = new AbstractJmsTopicDestination();
                    messagingDestination.setId(field.getName());
                    messagingDestination.setNoLocal(md.noLocal());
                    messagingDestination.setSessionSelector(md.sessionSelector());
                    if (md.securityRoles().length > 0) {
                        messagingDestination.setRoles(Arrays.asList(md.securityRoles()));
                    }
                    GraniteServlet3Initializer.initSecurizer(messagingDestination, md.securizer(), configProvider);
                    messagingDestination.initServices(servicesConfig);
                    ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
                    ((AbstractJmsTopicDestination)messagingDestination).setTextMessages(md.textMessages());
                    ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
                    ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
                    ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
                    ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
                    messagingDestination.initServices(servicesConfig);
                    continue;
                }
                if (field.isAnnotationPresent(ActiveMQTopicDestination.class)) {
                    md = field.getAnnotation(ActiveMQTopicDestination.class);
                    messagingDestination = new AbstractActiveMQTopicDestination();
                    messagingDestination.setId(field.getName());
                    messagingDestination.setNoLocal(md.noLocal());
                    messagingDestination.setSessionSelector(md.sessionSelector());
                    if (md.securityRoles().length > 0) {
                        messagingDestination.setRoles(Arrays.asList(md.securityRoles()));
                    }
                    GraniteServlet3Initializer.initSecurizer(messagingDestination, md.securizer(), configProvider);
                    messagingDestination.initServices(servicesConfig);
                    ((AbstractJmsTopicDestination)messagingDestination).setName(md.name());
                    ((AbstractJmsTopicDestination)messagingDestination).setTextMessages(md.textMessages());
                    ((AbstractJmsTopicDestination)messagingDestination).setAcknowledgeMode(md.acknowledgeMode());
                    ((AbstractJmsTopicDestination)messagingDestination).setConnectionFactory(md.connectionFactory());
                    ((AbstractJmsTopicDestination)messagingDestination).setTransactedSessions(md.transactedSessions());
                    ((AbstractJmsTopicDestination)messagingDestination).setJndiName(md.topicJndiName());
                    ((AbstractActiveMQTopicDestination)messagingDestination).setBrokerUrl(md.brokerUrl());
                    ((AbstractActiveMQTopicDestination)messagingDestination).setCreateBroker(md.createBroker());
                    ((AbstractActiveMQTopicDestination)messagingDestination).setDurable(md.durable());
                    ((AbstractActiveMQTopicDestination)messagingDestination).setWaitForStart(md.waitForStart());
                    ((AbstractActiveMQTopicDestination)messagingDestination).setFileStoreRoot(md.fileStoreRoot());
                    messagingDestination.initServices(servicesConfig);
                    continue;
                }
                for (Servlet3Configurator conf : configurators) {
                    if (conf.handleField(field, configProvider, servicesConfig)) break;
                }
            }
        }

        static {
            securityServicesMap.put("org.mortbay.jetty.Request", "org.granite.messaging.service.security.Jetty6SecurityService");
            securityServicesMap.put("org.eclipse.jetty.websocket.servlet.PostUpgradedHttpServletRequest", "org.granite.messaging.service.security.Jetty9SecurityService");
            securityServicesMap.put("org.eclipse.jetty.server.Authentication", "org.granite.messaging.service.security.Jetty8SecurityService");
            securityServicesMap.put("weblogic.servlet.security.ServletAuthentication", "org.granite.messaging.service.security.WebLogicSecurityService");
            securityServicesMap.put("com.sun.appserv.server.LifecycleEvent", "org.granite.messaging.service.security.GlassFishV3SecurityService");
            securityServicesMap.put("io.undertow.server.HttpServerExchange", "org.granite.messaging.service.security.UndertowSecurityService");
            securityServicesMap.put("org.apache.catalina.connector.Request", "org.granite.messaging.service.security.Tomcat7SecurityService");
        }
    }
}

