/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.granite.gravity.AsyncChannelRunner;
import org.granite.gravity.GravityConfig;
import org.granite.logging.Logger;

public class GravityPool {
    private static final Logger log = Logger.getLogger(GravityPool.class);
    public static final int DEFAULT_CORE_POOL_SIZE = 5;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 20;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 10000L;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private final ThreadPoolExecutor pool;
    private final int queueCapacity;

    public GravityPool() {
        this(5, 20, 10000L, Integer.MAX_VALUE);
    }

    public GravityPool(GravityConfig config) {
        this(config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveTimeMillis(), config.getQueueCapacity());
    }

    public GravityPool(int corePoolSize, int maximumPoolSize, long keepAliveTimeMillis, int queueCapacity) {
        log.info("Starting Gravity Pool (corePoolSize=%d, maximumPoolSize=%d, keepAliveTimeMillis=%d, queueCapacity=%d)...", corePoolSize, maximumPoolSize, keepAliveTimeMillis, queueCapacity);
        this.queueCapacity = queueCapacity;
        this.pool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTimeMillis, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new ThreadPoolExecutor.AbortPolicy());
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueRemainingCapacity() {
        return this.pool.getQueue().remainingCapacity();
    }

    public int getQueueSize() {
        return this.pool.getQueue().size();
    }

    public int getCorePoolSize() {
        return this.pool.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.pool.setCorePoolSize(corePoolSize);
    }

    public int getMaximumPoolSize() {
        return this.pool.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.pool.setMaximumPoolSize(maximumPoolSize);
    }

    public long getKeepAliveTimeMillis() {
        return this.pool.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTimeMillis(long keepAliveTimeMillis) {
        this.pool.setKeepAliveTime(keepAliveTimeMillis, TimeUnit.MILLISECONDS);
    }

    public void reconfigure(GravityConfig config) {
        this.pool.setCorePoolSize(config.getCorePoolSize());
        this.pool.setKeepAliveTime(config.getKeepAliveTimeMillis(), TimeUnit.MILLISECONDS);
        this.pool.setMaximumPoolSize(config.getMaximumPoolSize());
    }

    public void execute(AsyncChannelRunner runner) {
        if (runner == null) {
            throw new NullPointerException("runner cannot be null");
        }
        if (!this.pool.isShutdown()) {
            try {
                this.pool.execute(runner);
            }
            catch (RejectedExecutionException e) {
                runner.reset();
                throw e;
            }
        } else {
            runner.reset();
        }
    }

    public boolean contains(AsyncChannelRunner runner) {
        return this.pool.getQueue().contains(runner);
    }

    public boolean remove(AsyncChannelRunner runner) {
        if (this.pool.getQueue().remove(runner)) {
            runner.reset();
            return true;
        }
        return false;
    }

    public void clear() {
        ArrayList runnables = new ArrayList(this.pool.getQueue().size());
        this.pool.getQueue().drainTo(runnables);
        for (Runnable runnable : runnables) {
            ((AsyncChannelRunner)runnable).reset();
        }
    }

    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    public boolean isTerminated() {
        return this.pool.isTerminated();
    }

    public void shutdown() {
        log.info("Stopping Gravity Pool...", new Object[0]);
        this.pool.shutdown();
    }

    public List<AsyncChannelRunner> shutdownNow() {
        log.info("Stopping Gravity Pool Now...", new Object[0]);
        List<Runnable> runnables = this.pool.shutdownNow();
        ArrayList<AsyncChannelRunner> runners = new ArrayList<AsyncChannelRunner>(runnables.size());
        for (Runnable runnable : runnables) {
            AsyncChannelRunner runner = (AsyncChannelRunner)runnable;
            runner.reset();
            runners.add(runner);
        }
        return runners;
    }
}

