/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.generic;

import flex.messaging.messages.AsyncMessage;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.generic.GenericChannelFactory;
import org.granite.gravity.generic.WaitingContinuation;
import org.granite.logging.Logger;

public class GenericChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(GenericChannel.class);
    private WaitingContinuation continuation = null;

    public GenericChannel(GravityInternal gravity, String id, GenericChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(WaitingContinuation continuation) {
        try {
            if (this.continuation != null && this.continuation.isPending()) {
                log.debug("Set pending continuation for client: %s", this.getId());
                this.continuation.resume();
            }
        }
        finally {
            this.continuation = continuation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.continuation != null) {
                this.continuation.reset();
            }
        }
        finally {
            this.continuation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        try {
            if (this.continuation != null) {
                log.debug("Resume pending continuation for client: %s", this.getId());
                this.continuation.resume();
            }
        }
        finally {
            this.continuation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(AsyncMessage message) throws MessageReceivingException {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        this.receivedQueueLock.lock();
        try {
            this.receivedQueue.add(message);
        }
        catch (Exception e) {
            throw new MessageReceivingException(message, "Could not queue message", e);
        }
        finally {
            this.receivedQueueLock.unlock();
        }
        GenericChannel genericChannel = this;
        synchronized (genericChannel) {
            this.resume();
        }
    }

    @Override
    protected boolean hasAsyncHttpContext() {
        return false;
    }

    @Override
    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    @Override
    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean timeout) {
        try {
            super.destroy(timeout);
        }
        finally {
            GenericChannel genericChannel = this;
            synchronized (genericChannel) {
                this.close();
            }
        }
    }
}

