/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.glassfish.GlassFishWebSocketChannel;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.gravity.websocket.WebSocketUtil;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class GlassFishWebSocketApplication
extends WebSocketApplication {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketApplication.class);
    private final ServletContext servletContext;
    private final GravityInternal gravity;
    private final Pattern mapping;
    private final String servletName;
    private String protocol;

    public GlassFishWebSocketApplication(ServletContext servletContext, GravityInternal gravity, String mapping, String servletName) {
        this.servletContext = servletContext;
        this.gravity = gravity;
        this.mapping = Pattern.compile(".*" + mapping.replace("*", ".*") + "$");
        this.servletName = servletName;
    }

    public List<String> getSupportedProtocols(List<String> subProtocols) {
        for (String subProtocol : subProtocols) {
            if (!subProtocol.startsWith("org.granite.gravity")) continue;
            this.protocol = subProtocol;
            return Collections.singletonList(subProtocol);
        }
        return Collections.emptyList();
    }

    public boolean isApplicationRequest(Request request) {
        String uri = request.requestURI().toString();
        return this.mapping.matcher(uri).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(WebSocket websocket) {
        if (!(websocket instanceof DefaultWebSocket)) {
            throw new IllegalStateException("Only DefaultWebSocket supported");
        }
        GlassFishWebSocketChannelFactory channelFactory = new GlassFishWebSocketChannelFactory(this.gravity);
        HttpServletRequest request = ((DefaultWebSocket)websocket).getRequest();
        try {
            String connectMessageId = GlassFishWebSocketApplication.getHeaderOrParameter(request, "connectId");
            String clientId = GlassFishWebSocketApplication.getHeaderOrParameter(request, "GDSClientId");
            String clientType = GlassFishWebSocketApplication.getHeaderOrParameter(request, "GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession("true".equals(this.servletContext.getInitParameter("org.granite.gravity.websocket.forceCreateSession")));
            if (session != null) {
                ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, session, clientType);
                sessionId = session.getId();
            } else if (request.getCookies() != null) {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, sessionId, clientType);
            } else {
                ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, (String)null, clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", this.protocol, clientId, sessionId);
            if (this.gravity.getGraniteConfig().getSecurityService() != null) {
                this.gravity.getGraniteConfig().getSecurityService().prelogin(session, request, this.servletName);
            }
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            Message ackMessage = this.gravity.handleMessage(channelFactory, pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", sessionId);
            }
            GlassFishWebSocketChannel channel = this.gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            String ctype = request.getContentType();
            ContentType contentType = WebSocketUtil.getContentType(ctype, this.protocol);
            channel.setContentType(contentType);
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            channel.setWebSocket(websocket);
        }
        finally {
            GraniteContext.release();
        }
    }

    private static String getHeaderOrParameter(HttpServletRequest servletRequest, String key) {
        String value = servletRequest.getHeader(key);
        if (value == null) {
            value = servletRequest.getParameter(key);
        }
        return value;
    }
}

