/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.glassfish;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.glassfish.GlassFishWebSocketChannelFactory;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.logging.Logger;

public class GlassFishWebSocketChannel
extends AbstractWebSocketChannel
implements WebSocketListener {
    private static final Logger log = Logger.getLogger(GlassFishWebSocketChannel.class);
    private WebSocket websocket;

    public GlassFishWebSocketChannel(GravityInternal gravity, String id, GlassFishWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    public void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
        this.websocket.add((WebSocketListener)this);
        this.connect();
        this.gravity.notifyConnected(this);
    }

    public void onConnect(WebSocket websocket) {
        log.debug("Channel %s onConnect", this.getId());
    }

    public void onClose(WebSocket websocket, DataFrame frame) {
        log.debug("Channel %s onClose", this.getId());
        this.websocket = null;
        this.gravity.notifyDisconnected(this);
    }

    public void onMessage(WebSocket websocket, byte[] data) {
        super.receiveBytes(data, 0, data.length);
    }

    public void onMessage(WebSocket websocket, String message) {
        log.warn("Channel %s unsupported text message", this.getId());
    }

    public void onFragment(WebSocket websocket, String message, boolean isLast) {
        log.warn("Channel %s unsupported onFragment text message", this.getId());
    }

    public void onFragment(WebSocket websocket, byte[] data, boolean isLast) {
        log.warn("Channel %s unsupported onFragment binary message", this.getId());
    }

    public void onPing(WebSocket websocket, byte[] data) {
        log.warn("Channel %s unsupported onPing message", this.getId());
    }

    public void onPong(WebSocket websocket, byte[] data) {
        log.warn("Channel %s unsupported onPong message", this.getId());
    }

    @Override
    public boolean isConnected() {
        return this.websocket != null && this.websocket.isConnected();
    }

    @Override
    protected void sendBytes(byte[] msg) {
        this.websocket.send(msg);
    }

    @Override
    public void close() {
        if (this.websocket != null) {
            this.websocket.close(1000, "Channel closed");
            this.websocket = null;
            this.gravity.notifyDisconnected(this);
        }
    }
}

