/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.jetty.ContinuationChannel;
import org.granite.gravity.jetty.ContinuationChannelFactory;
import org.granite.logging.Logger;
import org.granite.util.ContentType;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class GravityJettyServlet
extends AbstractGravityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityJettyServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doPost: from %s:%d", request.getRemoteAddr(), request.getRemotePort());
        GravityInternal gravity = (GravityInternal)((Object)GravityManager.getGravity(this.getServletContext()));
        ContinuationChannelFactory channelFactory = new ContinuationChannelFactory(gravity);
        try {
            this.initializeRequest(gravity, request, response);
            CommandMessage connect = GravityJettyServlet.getConnectMessage(request);
            if (connect != null) {
                ContinuationChannel channel;
                String channelId = (String)connect.getClientId();
                ContinuationChannel continuationChannel = channel = gravity.getChannel(channelFactory, channelId);
                synchronized (continuationChannel) {
                    channel.close();
                    channel.runReceived(new AsyncHttpContext(request, response, connect));
                }
                return;
            }
            Message[] amf3Requests = this.deserialize(gravity, request);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one request is allowed on tunnel.");
                    }
                    ContinuationChannel channel = gravity.getChannel(channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (!channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        GravityJettyServlet.setConnectMessage(request, amf3Request);
                        ContinuationChannel continuationChannel = channel;
                        synchronized (continuationChannel) {
                            Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, (Object)channel);
                            channel.setContinuation(continuation);
                            continuation.suspend(this.getLongPollingTimeout());
                        }
                    }
                    return;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses, ContentType.forMimeType(request.getContentType()));
        }
        catch (RetryRequest e) {
            throw e;
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            this.cleanupRequest(request);
        }
    }
}

