/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty8;

import java.io.IOException;
import org.eclipse.jetty.websocket.WebSocket;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.jetty8.JettyWebSocketChannelFactory;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.logging.Logger;

public class JettyWebSocketChannel
extends AbstractWebSocketChannel
implements WebSocket,
WebSocket.OnBinaryMessage {
    private static final Logger log = Logger.getLogger(JettyWebSocketChannel.class);
    private WebSocket.Connection connection;

    public JettyWebSocketChannel(GravityInternal gravity, String id, JettyWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.connection.setMaxIdleTime((int)this.getGravity().getGravityConfig().getChannelIdleTimeoutMillis());
        this.setMaxBinaryMessageBufferSize(connection.getMaxBinaryMessageSize());
        this.connect();
        this.gravity.notifyConnected(this);
    }

    public void onClose(int closeCode, String message) {
        log.debug("Channel %s websocket connection onClose %d, %s", this.getId(), closeCode, message);
        this.connection = null;
        this.gravity.notifyDisconnected(this);
    }

    public void onMessage(byte[] data, int offset, int length) {
        this.receiveBytes(data, offset, length);
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen();
    }

    @Override
    protected void sendBytes(byte[] msg) throws IOException {
        if (this.connection != null) {
            this.connection.sendMessage(msg, 0, msg.length);
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close(1000, "Channel closed");
            this.connection = null;
            this.gravity.notifyDisconnected(this);
        }
    }
}

