/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty8;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;
import org.granite.context.GraniteContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.jetty8.JettyWebSocketChannel;
import org.granite.gravity.jetty8.JettyWebSocketChannelFactory;
import org.granite.gravity.websocket.WebSocketUtil;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class JettyWebSocketHandler
extends WebSocketHandler {
    private static final Logger log = Logger.getLogger(JettyWebSocketHandler.class);
    private final ServletContext servletContext;

    public JettyWebSocketHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        if (!protocol.startsWith("org.granite.gravity")) {
            return null;
        }
        GravityInternal gravity = (GravityInternal)((Object)GravityManager.getGravity(this.servletContext));
        JettyWebSocketChannelFactory channelFactory = new JettyWebSocketChannelFactory(gravity);
        try {
            String connectMessageId = JettyWebSocketHandler.getHeaderOrParameter(request, "connectId");
            String clientId = JettyWebSocketHandler.getHeaderOrParameter(request, "GDSClientId");
            String clientType = JettyWebSocketHandler.getHeaderOrParameter(request, "GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession("true".equals(this.servletContext.getInitParameter("org.granite.gravity.websocket.forceCreateSession")));
            if (session != null) {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.servletContext, session, clientType);
                sessionId = session.getId();
            } else if (request.getCookies() != null) {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.servletContext, sessionId, clientType);
            } else {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.servletContext, (String)null, clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", protocol, clientId, sessionId);
            if (gravity.getGraniteConfig().getSecurityService() != null) {
                gravity.getGraniteConfig().getSecurityService().prelogin(session, request, null);
            }
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            Message ackMessage = gravity.handleMessage(channelFactory, pingMessage);
            if (sessionId != null) {
                ackMessage.setHeader("JSESSIONID", sessionId);
            }
            JettyWebSocketChannel channel = gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            channel.setSession(session);
            String ctype = request.getContentType();
            ContentType contentType = WebSocketUtil.getContentType(ctype, protocol);
            channel.setContentType(contentType);
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            JettyWebSocketChannel jettyWebSocketChannel = channel;
            return jettyWebSocketChannel;
        }
        finally {
            GraniteContext.release();
        }
    }

    private static String getHeaderOrParameter(HttpServletRequest servletRequest, String key) {
        String value = servletRequest.getHeader(key);
        if (value == null) {
            value = servletRequest.getParameter(key);
        }
        return value;
    }
}

