/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty9;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.jetty9.JettyWebSocketChannelFactory;
import org.granite.gravity.websocket.AbstractWebSocketChannel;
import org.granite.logging.Logger;

public class JettyWebSocketChannel
extends AbstractWebSocketChannel
implements WebSocketListener {
    private static final Logger log = Logger.getLogger(JettyWebSocketChannel.class);
    private Session socketSession;

    public JettyWebSocketChannel(GravityInternal gravity, String id, JettyWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
        log.debug("Create channel %s", this.getId());
    }

    public void onWebSocketConnect(Session session) {
        this.socketSession = session;
        this.socketSession.setIdleTimeout(this.getGravity().getGravityConfig().getChannelIdleTimeoutMillis());
        this.setMaxBinaryMessageBufferSize(this.socketSession.getPolicy().getMaxBinaryMessageBufferSize());
        this.connect();
        this.gravity.notifyConnected(this);
        log.debug("Channel %s websocket connected %s", this.getId(), this.socketSession.isOpen() ? "(open)" : "(closed)");
    }

    public void onWebSocketBinary(byte[] data, int offset, int length) {
        super.receiveBytes(data, offset, length);
    }

    public void onWebSocketClose(int closeCode, String message) {
        log.debug("Channel %s websocket connection onClose %d, %s", this.getId(), closeCode, message);
        this.socketSession = null;
        this.gravity.notifyDisconnected(this);
    }

    public void onWebSocketError(Throwable throwable) {
        log.error(throwable, "Channel %s websocket error", new Object[0]);
    }

    public void onWebSocketText(String s) {
        log.warn("Channel %s unsupported text message", this.getId());
    }

    @Override
    public boolean isConnected() {
        log.debug("Channel %s websocket connection %s", this.getId(), this.socketSession == null ? "(null)" : (this.socketSession.isOpen() ? "(open)" : "(not open)"));
        return this.socketSession != null && this.socketSession.isOpen();
    }

    @Override
    protected void sendBytes(byte[] msg) throws IOException {
        this.socketSession.getRemote().sendBytes(ByteBuffer.wrap(msg));
    }

    @Override
    public void close() {
        log.debug("Channel %s close", this.getId());
        if (this.socketSession != null) {
            this.socketSession.close(1000, "Channel closed");
            this.socketSession = null;
            this.gravity.notifyDisconnected(this);
        }
    }
}

