/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.servlet3;

import flex.messaging.messages.Message;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.gravity.servlet3.AsyncChannel;
import org.granite.gravity.servlet3.AsyncChannelFactory;
import org.granite.gravity.servlet3.AsyncRequestListener;
import org.granite.logging.Logger;
import org.granite.util.ContentType;

public class GravityAsyncServlet
extends AbstractGravityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityAsyncServlet.class);

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.isAsyncSupported()) {
            throw new ServletException("Asynchronous requests are not supported with this servlet. Please check your web.xml");
        }
        if (request.isAsyncStarted()) {
            throw new ServletException("Gravity Servlet3 implementation doesn't support dispatch(...) mode");
        }
        GravityInternal gravity = (GravityInternal)((Object)GravityManager.getGravity(this.getServletContext()));
        AsyncChannelFactory channelFactory = new AsyncChannelFactory(gravity);
        try {
            this.initializeRequest(gravity, request, response);
            Message[] amf3Requests = this.deserialize(gravity, request);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one connect request is allowed on tunnel.");
                    }
                    AsyncChannel channel = gravity.getChannel(channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (!channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        GravityAsyncServlet.setConnectMessage(request, amf3Request);
                        AsyncContext asyncContext = request.startAsync();
                        asyncContext.setTimeout(this.getLongPollingTimeout());
                        try {
                            asyncContext.addListener((AsyncListener)new AsyncRequestListener(channel));
                            channel.setAsyncContext(asyncContext);
                        }
                        catch (Exception e) {
                            log.error(e, "Error while setting async context. Closing context...", new Object[0]);
                            asyncContext.complete();
                        }
                    }
                    return;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses, ContentType.forMimeType(request.getContentType()));
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            this.cleanupRequest(request);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

